package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTPasswdIdentityProviderBuilder extends HTPasswdIdentityProviderFluentImpl<HTPasswdIdentityProviderBuilder> implements VisitableBuilder<HTPasswdIdentityProvider,HTPasswdIdentityProviderBuilder>{
  public HTPasswdIdentityProviderBuilder() {
    this(false);
  }
  public HTPasswdIdentityProviderBuilder(Boolean validationEnabled) {
    this(new HTPasswdIdentityProvider(), validationEnabled);
  }
  public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTPasswdIdentityProvider(), validationEnabled);
  }
  public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProviderFluent<?> fluent,HTPasswdIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProviderFluent<?> fluent,HTPasswdIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFileData(instance.getFileData()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProvider instance) {
    this(instance,false);
  }
  public HTPasswdIdentityProviderBuilder(HTPasswdIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFileData(instance.getFileData()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTPasswdIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public HTPasswdIdentityProvider build() {
    HTPasswdIdentityProvider buildable = new HTPasswdIdentityProvider(fluent.getFileData());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}