package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildOverridesBuilder extends BuildOverridesFluentImpl<BuildOverridesBuilder> implements VisitableBuilder<BuildOverrides,BuildOverridesBuilder>{
  public BuildOverridesBuilder() {
    this(false);
  }
  public BuildOverridesBuilder(Boolean validationEnabled) {
    this(new BuildOverrides(), validationEnabled);
  }
  public BuildOverridesBuilder(BuildOverridesFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildOverridesBuilder(BuildOverridesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BuildOverrides(), validationEnabled);
  }
  public BuildOverridesBuilder(BuildOverridesFluent<?> fluent,BuildOverrides instance) {
    this(fluent, instance, false);
  }
  public BuildOverridesBuilder(BuildOverridesFluent<?> fluent,BuildOverrides instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withForcePull(instance.getForcePull()); 
    fluent.withImageLabels(instance.getImageLabels()); 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withTolerations(instance.getTolerations()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BuildOverridesBuilder(BuildOverrides instance) {
    this(instance,false);
  }
  public BuildOverridesBuilder(BuildOverrides instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withForcePull(instance.getForcePull()); 
    this.withImageLabels(instance.getImageLabels()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withTolerations(instance.getTolerations()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BuildOverridesFluent<?> fluent;
  Boolean validationEnabled;
  public BuildOverrides build() {
    BuildOverrides buildable = new BuildOverrides(fluent.getForcePull(),fluent.getImageLabels(),fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}