package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSPlatformSpecBuilder extends AWSPlatformSpecFluentImpl<AWSPlatformSpecBuilder> implements VisitableBuilder<AWSPlatformSpec,AWSPlatformSpecBuilder>{
  public AWSPlatformSpecBuilder() {
    this(false);
  }
  public AWSPlatformSpecBuilder(Boolean validationEnabled) {
    this(new AWSPlatformSpec(), validationEnabled);
  }
  public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSPlatformSpec(), validationEnabled);
  }
  public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent,AWSPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent,AWSPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withServiceEndpoints(instance.getServiceEndpoints()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSPlatformSpecBuilder(AWSPlatformSpec instance) {
    this(instance,false);
  }
  public AWSPlatformSpecBuilder(AWSPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withServiceEndpoints(instance.getServiceEndpoints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AWSPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AWSPlatformSpec build() {
    AWSPlatformSpec buildable = new AWSPlatformSpec(fluent.getServiceEndpoints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}