package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OpenIDIdentityProviderBuilder extends OpenIDIdentityProviderFluent<OpenIDIdentityProviderBuilder> implements VisitableBuilder<OpenIDIdentityProvider,OpenIDIdentityProviderBuilder>{
  public OpenIDIdentityProviderBuilder() {
    this(new OpenIDIdentityProvider());
  }
  
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent) {
    this(fluent, new OpenIDIdentityProvider());
  }
  
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProviderFluent<?> fluent,OpenIDIdentityProvider instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OpenIDIdentityProviderBuilder(OpenIDIdentityProvider instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OpenIDIdentityProviderFluent<?> fluent;
  
  public OpenIDIdentityProvider build() {
    OpenIDIdentityProvider buildable = new OpenIDIdentityProvider(fluent.buildCa(),fluent.buildClaims(),fluent.getClientID(),fluent.buildClientSecret(),fluent.getExtraAuthorizeParameters(),fluent.getExtraScopes(),fluent.getIssuer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}