package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OAuthSpecBuilder extends OAuthSpecFluent<OAuthSpecBuilder> implements VisitableBuilder<OAuthSpec,OAuthSpecBuilder>{
  public OAuthSpecBuilder() {
    this(new OAuthSpec());
  }
  
  public OAuthSpecBuilder(OAuthSpecFluent<?> fluent) {
    this(fluent, new OAuthSpec());
  }
  
  public OAuthSpecBuilder(OAuthSpecFluent<?> fluent,OAuthSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OAuthSpecBuilder(OAuthSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OAuthSpecFluent<?> fluent;
  
  public OAuthSpec build() {
    OAuthSpec buildable = new OAuthSpec(fluent.buildIdentityProviders(),fluent.buildTemplates(),fluent.buildTokenConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}