package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LDAPIdentityProviderBuilder extends LDAPIdentityProviderFluent<LDAPIdentityProviderBuilder> implements VisitableBuilder<LDAPIdentityProvider,LDAPIdentityProviderBuilder>{
  public LDAPIdentityProviderBuilder() {
    this(new LDAPIdentityProvider());
  }
  
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent) {
    this(fluent, new LDAPIdentityProvider());
  }
  
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,LDAPIdentityProvider instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LDAPIdentityProviderBuilder(LDAPIdentityProvider instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LDAPIdentityProviderFluent<?> fluent;
  
  public LDAPIdentityProvider build() {
    LDAPIdentityProvider buildable = new LDAPIdentityProvider(fluent.buildAttributes(),fluent.getBindDN(),fluent.buildBindPassword(),fluent.buildCa(),fluent.getInsecure(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}