package io.fabric8.openshift.api.model.clusterautoscaling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineAutoscalerStatusBuilder extends MachineAutoscalerStatusFluentImpl<MachineAutoscalerStatusBuilder> implements VisitableBuilder<MachineAutoscalerStatus,MachineAutoscalerStatusBuilder>{
  public MachineAutoscalerStatusBuilder() {
    this(false);
  }
  public MachineAutoscalerStatusBuilder(Boolean validationEnabled) {
    this(new MachineAutoscalerStatus(), validationEnabled);
  }
  public MachineAutoscalerStatusBuilder(MachineAutoscalerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineAutoscalerStatusBuilder(MachineAutoscalerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineAutoscalerStatus(), validationEnabled);
  }
  public MachineAutoscalerStatusBuilder(MachineAutoscalerStatusFluent<?> fluent,MachineAutoscalerStatus instance) {
    this(fluent, instance, false);
  }
  public MachineAutoscalerStatusBuilder(MachineAutoscalerStatusFluent<?> fluent,MachineAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTargetRef(instance.getLastTargetRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineAutoscalerStatusBuilder(MachineAutoscalerStatus instance) {
    this(instance,false);
  }
  public MachineAutoscalerStatusBuilder(MachineAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTargetRef(instance.getLastTargetRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineAutoscalerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MachineAutoscalerStatus build() {
    MachineAutoscalerStatus buildable = new MachineAutoscalerStatus(fluent.getLastTargetRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}