package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterAutoscalerStatusBuilder extends ClusterAutoscalerStatusFluentImpl<ClusterAutoscalerStatusBuilder> implements VisitableBuilder<ClusterAutoscalerStatus,ClusterAutoscalerStatusBuilder>{
  public ClusterAutoscalerStatusBuilder() {
    this(false);
  }
  public ClusterAutoscalerStatusBuilder(Boolean validationEnabled) {
    this(new ClusterAutoscalerStatus(), validationEnabled);
  }
  public ClusterAutoscalerStatusBuilder(ClusterAutoscalerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterAutoscalerStatusBuilder(ClusterAutoscalerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterAutoscalerStatus(), validationEnabled);
  }
  public ClusterAutoscalerStatusBuilder(ClusterAutoscalerStatusFluent<?> fluent,ClusterAutoscalerStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterAutoscalerStatusBuilder(ClusterAutoscalerStatusFluent<?> fluent,ClusterAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterAutoscalerStatusBuilder(ClusterAutoscalerStatus instance) {
    this(instance,false);
  }
  public ClusterAutoscalerStatusBuilder(ClusterAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterAutoscalerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterAutoscalerStatus build() {
    ClusterAutoscalerStatus buildable = new ClusterAutoscalerStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}