package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterAutoscalerSpecBuilder extends ClusterAutoscalerSpecFluentImpl<ClusterAutoscalerSpecBuilder> implements VisitableBuilder<ClusterAutoscalerSpec,ClusterAutoscalerSpecBuilder>{
  public ClusterAutoscalerSpecBuilder() {
    this(false);
  }
  public ClusterAutoscalerSpecBuilder(Boolean validationEnabled) {
    this(new ClusterAutoscalerSpec(), validationEnabled);
  }
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterAutoscalerSpec(), validationEnabled);
  }
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent,ClusterAutoscalerSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpecFluent<?> fluent,ClusterAutoscalerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups());
      fluent.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization());
      fluent.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime());
      fluent.withMaxPodGracePeriod(instance.getMaxPodGracePeriod());
      fluent.withPodPriorityThreshold(instance.getPodPriorityThreshold());
      fluent.withResourceLimits(instance.getResourceLimits());
      fluent.withScaleDown(instance.getScaleDown());
      fluent.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpec instance) {
    this(instance,false);
  }
  public ClusterAutoscalerSpecBuilder(ClusterAutoscalerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups());
      this.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization());
      this.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime());
      this.withMaxPodGracePeriod(instance.getMaxPodGracePeriod());
      this.withPodPriorityThreshold(instance.getPodPriorityThreshold());
      this.withResourceLimits(instance.getResourceLimits());
      this.withScaleDown(instance.getScaleDown());
      this.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterAutoscalerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterAutoscalerSpec build() {
    ClusterAutoscalerSpec buildable = new ClusterAutoscalerSpec(fluent.getBalanceSimilarNodeGroups(),fluent.getIgnoreDaemonsetsUtilization(),fluent.getMaxNodeProvisionTime(),fluent.getMaxPodGracePeriod(),fluent.getPodPriorityThreshold(),fluent.getResourceLimits(),fluent.getScaleDown(),fluent.getSkipNodesWithLocalStorage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}