package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterAutoscalerBuilder extends ClusterAutoscalerFluentImpl<ClusterAutoscalerBuilder> implements VisitableBuilder<ClusterAutoscaler,ClusterAutoscalerBuilder>{
  public ClusterAutoscalerBuilder() {
    this(false);
  }
  public ClusterAutoscalerBuilder(Boolean validationEnabled) {
    this(new ClusterAutoscaler(), validationEnabled);
  }
  public ClusterAutoscalerBuilder(ClusterAutoscalerFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterAutoscalerBuilder(ClusterAutoscalerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterAutoscaler(), validationEnabled);
  }
  public ClusterAutoscalerBuilder(ClusterAutoscalerFluent<?> fluent,ClusterAutoscaler instance) {
    this(fluent, instance, false);
  }
  public ClusterAutoscalerBuilder(ClusterAutoscalerFluent<?> fluent,ClusterAutoscaler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterAutoscalerBuilder(ClusterAutoscaler instance) {
    this(instance,false);
  }
  public ClusterAutoscalerBuilder(ClusterAutoscaler instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterAutoscalerFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterAutoscaler build() {
    ClusterAutoscaler buildable = new ClusterAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}