package io.fabric8.openshift.api.model.clusterautoscaling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineAutoscalerBuilder extends MachineAutoscalerFluentImpl<MachineAutoscalerBuilder> implements VisitableBuilder<MachineAutoscaler,MachineAutoscalerBuilder>{
  public MachineAutoscalerBuilder() {
    this(false);
  }
  public MachineAutoscalerBuilder(Boolean validationEnabled) {
    this(new MachineAutoscaler(), validationEnabled);
  }
  public MachineAutoscalerBuilder(MachineAutoscalerFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineAutoscalerBuilder(MachineAutoscalerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineAutoscaler(), validationEnabled);
  }
  public MachineAutoscalerBuilder(MachineAutoscalerFluent<?> fluent,MachineAutoscaler instance) {
    this(fluent, instance, false);
  }
  public MachineAutoscalerBuilder(MachineAutoscalerFluent<?> fluent,MachineAutoscaler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineAutoscalerBuilder(MachineAutoscaler instance) {
    this(instance,false);
  }
  public MachineAutoscalerBuilder(MachineAutoscaler instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachineAutoscalerFluent<?> fluent;
  Boolean validationEnabled;
  public MachineAutoscaler build() {
    MachineAutoscaler buildable = new MachineAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}