package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GPULimitBuilder extends GPULimitFluentImpl<GPULimitBuilder> implements VisitableBuilder<GPULimit,GPULimitBuilder>{
  public GPULimitBuilder() {
    this(false);
  }
  public GPULimitBuilder(Boolean validationEnabled) {
    this(new GPULimit(), validationEnabled);
  }
  public GPULimitBuilder(GPULimitFluent<?> fluent) {
    this(fluent, false);
  }
  public GPULimitBuilder(GPULimitFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GPULimit(), validationEnabled);
  }
  public GPULimitBuilder(GPULimitFluent<?> fluent,GPULimit instance) {
    this(fluent, instance, false);
  }
  public GPULimitBuilder(GPULimitFluent<?> fluent,GPULimit instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMax(instance.getMax()); 
    fluent.withMin(instance.getMin()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GPULimitBuilder(GPULimit instance) {
    this(instance,false);
  }
  public GPULimitBuilder(GPULimit instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMax(instance.getMax()); 
    this.withMin(instance.getMin()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GPULimitFluent<?> fluent;
  Boolean validationEnabled;
  public GPULimit build() {
    GPULimit buildable = new GPULimit(fluent.getMax(),fluent.getMin(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}