package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterAutoscalerListBuilder extends ClusterAutoscalerListFluentImpl<ClusterAutoscalerListBuilder> implements VisitableBuilder<ClusterAutoscalerList,ClusterAutoscalerListBuilder>{
  public ClusterAutoscalerListBuilder() {
    this(false);
  }
  public ClusterAutoscalerListBuilder(Boolean validationEnabled) {
    this(new ClusterAutoscalerList(), validationEnabled);
  }
  public ClusterAutoscalerListBuilder(ClusterAutoscalerListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterAutoscalerListBuilder(ClusterAutoscalerListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterAutoscalerList(), validationEnabled);
  }
  public ClusterAutoscalerListBuilder(ClusterAutoscalerListFluent<?> fluent,ClusterAutoscalerList instance) {
    this(fluent, instance, false);
  }
  public ClusterAutoscalerListBuilder(ClusterAutoscalerListFluent<?> fluent,ClusterAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterAutoscalerListBuilder(ClusterAutoscalerList instance) {
    this(instance,false);
  }
  public ClusterAutoscalerListBuilder(ClusterAutoscalerList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterAutoscalerListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterAutoscalerList build() {
    ClusterAutoscalerList buildable = new ClusterAutoscalerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}