package io.fabric8.openshift.api.model.clusterautoscaling.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterAutoscalerSpecFluent<A extends ClusterAutoscalerSpecFluent<A>> extends BaseFluent<A>{
  public ClusterAutoscalerSpecFluent() {
  }
  
  public ClusterAutoscalerSpecFluent(ClusterAutoscalerSpec instance) {
    this.copyInstance(instance);
  }
  private Boolean balanceSimilarNodeGroups;
  private List<String> balancingIgnoredLabels = new ArrayList<String>();
  private Boolean ignoreDaemonsetsUtilization;
  private Integer logVerbosity;
  private String maxNodeProvisionTime;
  private Integer maxPodGracePeriod;
  private Integer podPriorityThreshold;
  private ResourceLimitsBuilder resourceLimits;
  private ScaleDownConfigBuilder scaleDown;
  private Boolean skipNodesWithLocalStorage;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterAutoscalerSpec instance) {
    instance = (instance != null ? instance : new ClusterAutoscalerSpec());
    if (instance != null) {
          this.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups());
          this.withBalancingIgnoredLabels(instance.getBalancingIgnoredLabels());
          this.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization());
          this.withLogVerbosity(instance.getLogVerbosity());
          this.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime());
          this.withMaxPodGracePeriod(instance.getMaxPodGracePeriod());
          this.withPodPriorityThreshold(instance.getPodPriorityThreshold());
          this.withResourceLimits(instance.getResourceLimits());
          this.withScaleDown(instance.getScaleDown());
          this.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getBalanceSimilarNodeGroups() {
    return this.balanceSimilarNodeGroups;
  }
  
  public A withBalanceSimilarNodeGroups(Boolean balanceSimilarNodeGroups) {
    this.balanceSimilarNodeGroups = balanceSimilarNodeGroups;
    return (A) this;
  }
  
  public boolean hasBalanceSimilarNodeGroups() {
    return this.balanceSimilarNodeGroups != null;
  }
  
  public A addToBalancingIgnoredLabels(int index,String item) {
    if (this.balancingIgnoredLabels == null) {this.balancingIgnoredLabels = new ArrayList<String>();}
    this.balancingIgnoredLabels.add(index, item);
    return (A)this;
  }
  
  public A setToBalancingIgnoredLabels(int index,String item) {
    if (this.balancingIgnoredLabels == null) {this.balancingIgnoredLabels = new ArrayList<String>();}
    this.balancingIgnoredLabels.set(index, item); return (A)this;
  }
  
  public A addToBalancingIgnoredLabels(java.lang.String... items) {
    if (this.balancingIgnoredLabels == null) {this.balancingIgnoredLabels = new ArrayList<String>();}
    for (String item : items) {this.balancingIgnoredLabels.add(item);} return (A)this;
  }
  
  public A addAllToBalancingIgnoredLabels(Collection<String> items) {
    if (this.balancingIgnoredLabels == null) {this.balancingIgnoredLabels = new ArrayList<String>();}
    for (String item : items) {this.balancingIgnoredLabels.add(item);} return (A)this;
  }
  
  public A removeFromBalancingIgnoredLabels(java.lang.String... items) {
    if (this.balancingIgnoredLabels == null) return (A)this;
    for (String item : items) { this.balancingIgnoredLabels.remove(item);} return (A)this;
  }
  
  public A removeAllFromBalancingIgnoredLabels(Collection<String> items) {
    if (this.balancingIgnoredLabels == null) return (A)this;
    for (String item : items) { this.balancingIgnoredLabels.remove(item);} return (A)this;
  }
  
  public List<String> getBalancingIgnoredLabels() {
    return this.balancingIgnoredLabels;
  }
  
  public String getBalancingIgnoredLabel(int index) {
    return this.balancingIgnoredLabels.get(index);
  }
  
  public String getFirstBalancingIgnoredLabel() {
    return this.balancingIgnoredLabels.get(0);
  }
  
  public String getLastBalancingIgnoredLabel() {
    return this.balancingIgnoredLabels.get(balancingIgnoredLabels.size() - 1);
  }
  
  public String getMatchingBalancingIgnoredLabel(Predicate<String> predicate) {
      for (String item : balancingIgnoredLabels) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingBalancingIgnoredLabel(Predicate<String> predicate) {
      for (String item : balancingIgnoredLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBalancingIgnoredLabels(List<String> balancingIgnoredLabels) {
    if (balancingIgnoredLabels != null) {
        this.balancingIgnoredLabels = new ArrayList();
        for (String item : balancingIgnoredLabels) {
          this.addToBalancingIgnoredLabels(item);
        }
    } else {
      this.balancingIgnoredLabels = null;
    }
    return (A) this;
  }
  
  public A withBalancingIgnoredLabels(java.lang.String... balancingIgnoredLabels) {
    if (this.balancingIgnoredLabels != null) {
        this.balancingIgnoredLabels.clear();
        _visitables.remove("balancingIgnoredLabels");
    }
    if (balancingIgnoredLabels != null) {
      for (String item : balancingIgnoredLabels) {
        this.addToBalancingIgnoredLabels(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBalancingIgnoredLabels() {
    return this.balancingIgnoredLabels != null && !this.balancingIgnoredLabels.isEmpty();
  }
  
  public Boolean getIgnoreDaemonsetsUtilization() {
    return this.ignoreDaemonsetsUtilization;
  }
  
  public A withIgnoreDaemonsetsUtilization(Boolean ignoreDaemonsetsUtilization) {
    this.ignoreDaemonsetsUtilization = ignoreDaemonsetsUtilization;
    return (A) this;
  }
  
  public boolean hasIgnoreDaemonsetsUtilization() {
    return this.ignoreDaemonsetsUtilization != null;
  }
  
  public Integer getLogVerbosity() {
    return this.logVerbosity;
  }
  
  public A withLogVerbosity(Integer logVerbosity) {
    this.logVerbosity = logVerbosity;
    return (A) this;
  }
  
  public boolean hasLogVerbosity() {
    return this.logVerbosity != null;
  }
  
  public String getMaxNodeProvisionTime() {
    return this.maxNodeProvisionTime;
  }
  
  public A withMaxNodeProvisionTime(String maxNodeProvisionTime) {
    this.maxNodeProvisionTime = maxNodeProvisionTime;
    return (A) this;
  }
  
  public boolean hasMaxNodeProvisionTime() {
    return this.maxNodeProvisionTime != null;
  }
  
  public Integer getMaxPodGracePeriod() {
    return this.maxPodGracePeriod;
  }
  
  public A withMaxPodGracePeriod(Integer maxPodGracePeriod) {
    this.maxPodGracePeriod = maxPodGracePeriod;
    return (A) this;
  }
  
  public boolean hasMaxPodGracePeriod() {
    return this.maxPodGracePeriod != null;
  }
  
  public Integer getPodPriorityThreshold() {
    return this.podPriorityThreshold;
  }
  
  public A withPodPriorityThreshold(Integer podPriorityThreshold) {
    this.podPriorityThreshold = podPriorityThreshold;
    return (A) this;
  }
  
  public boolean hasPodPriorityThreshold() {
    return this.podPriorityThreshold != null;
  }
  
  public ResourceLimits buildResourceLimits() {
    return this.resourceLimits != null ? this.resourceLimits.build() : null;
  }
  
  public A withResourceLimits(ResourceLimits resourceLimits) {
    this._visitables.remove("resourceLimits");
    if (resourceLimits != null) {
        this.resourceLimits = new ResourceLimitsBuilder(resourceLimits);
        this._visitables.get("resourceLimits").add(this.resourceLimits);
    } else {
        this.resourceLimits = null;
        this._visitables.get("resourceLimits").remove(this.resourceLimits);
    }
    return (A) this;
  }
  
  public boolean hasResourceLimits() {
    return this.resourceLimits != null;
  }
  
  public ResourceLimitsNested<A> withNewResourceLimits() {
    return new ResourceLimitsNested(null);
  }
  
  public ResourceLimitsNested<A> withNewResourceLimitsLike(ResourceLimits item) {
    return new ResourceLimitsNested(item);
  }
  
  public ResourceLimitsNested<A> editResourceLimits() {
    return withNewResourceLimitsLike(java.util.Optional.ofNullable(buildResourceLimits()).orElse(null));
  }
  
  public ResourceLimitsNested<A> editOrNewResourceLimits() {
    return withNewResourceLimitsLike(java.util.Optional.ofNullable(buildResourceLimits()).orElse(new ResourceLimitsBuilder().build()));
  }
  
  public ResourceLimitsNested<A> editOrNewResourceLimitsLike(ResourceLimits item) {
    return withNewResourceLimitsLike(java.util.Optional.ofNullable(buildResourceLimits()).orElse(item));
  }
  
  public ScaleDownConfig buildScaleDown() {
    return this.scaleDown != null ? this.scaleDown.build() : null;
  }
  
  public A withScaleDown(ScaleDownConfig scaleDown) {
    this._visitables.remove("scaleDown");
    if (scaleDown != null) {
        this.scaleDown = new ScaleDownConfigBuilder(scaleDown);
        this._visitables.get("scaleDown").add(this.scaleDown);
    } else {
        this.scaleDown = null;
        this._visitables.get("scaleDown").remove(this.scaleDown);
    }
    return (A) this;
  }
  
  public boolean hasScaleDown() {
    return this.scaleDown != null;
  }
  
  public ScaleDownNested<A> withNewScaleDown() {
    return new ScaleDownNested(null);
  }
  
  public ScaleDownNested<A> withNewScaleDownLike(ScaleDownConfig item) {
    return new ScaleDownNested(item);
  }
  
  public ScaleDownNested<A> editScaleDown() {
    return withNewScaleDownLike(java.util.Optional.ofNullable(buildScaleDown()).orElse(null));
  }
  
  public ScaleDownNested<A> editOrNewScaleDown() {
    return withNewScaleDownLike(java.util.Optional.ofNullable(buildScaleDown()).orElse(new ScaleDownConfigBuilder().build()));
  }
  
  public ScaleDownNested<A> editOrNewScaleDownLike(ScaleDownConfig item) {
    return withNewScaleDownLike(java.util.Optional.ofNullable(buildScaleDown()).orElse(item));
  }
  
  public Boolean getSkipNodesWithLocalStorage() {
    return this.skipNodesWithLocalStorage;
  }
  
  public A withSkipNodesWithLocalStorage(Boolean skipNodesWithLocalStorage) {
    this.skipNodesWithLocalStorage = skipNodesWithLocalStorage;
    return (A) this;
  }
  
  public boolean hasSkipNodesWithLocalStorage() {
    return this.skipNodesWithLocalStorage != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterAutoscalerSpecFluent that = (ClusterAutoscalerSpecFluent) o;
    if (!java.util.Objects.equals(balanceSimilarNodeGroups, that.balanceSimilarNodeGroups)) return false;
    if (!java.util.Objects.equals(balancingIgnoredLabels, that.balancingIgnoredLabels)) return false;
    if (!java.util.Objects.equals(ignoreDaemonsetsUtilization, that.ignoreDaemonsetsUtilization)) return false;
    if (!java.util.Objects.equals(logVerbosity, that.logVerbosity)) return false;
    if (!java.util.Objects.equals(maxNodeProvisionTime, that.maxNodeProvisionTime)) return false;
    if (!java.util.Objects.equals(maxPodGracePeriod, that.maxPodGracePeriod)) return false;
    if (!java.util.Objects.equals(podPriorityThreshold, that.podPriorityThreshold)) return false;
    if (!java.util.Objects.equals(resourceLimits, that.resourceLimits)) return false;
    if (!java.util.Objects.equals(scaleDown, that.scaleDown)) return false;
    if (!java.util.Objects.equals(skipNodesWithLocalStorage, that.skipNodesWithLocalStorage)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(balanceSimilarNodeGroups,  balancingIgnoredLabels,  ignoreDaemonsetsUtilization,  logVerbosity,  maxNodeProvisionTime,  maxPodGracePeriod,  podPriorityThreshold,  resourceLimits,  scaleDown,  skipNodesWithLocalStorage,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (balanceSimilarNodeGroups != null) { sb.append("balanceSimilarNodeGroups:"); sb.append(balanceSimilarNodeGroups + ","); }
    if (balancingIgnoredLabels != null && !balancingIgnoredLabels.isEmpty()) { sb.append("balancingIgnoredLabels:"); sb.append(balancingIgnoredLabels + ","); }
    if (ignoreDaemonsetsUtilization != null) { sb.append("ignoreDaemonsetsUtilization:"); sb.append(ignoreDaemonsetsUtilization + ","); }
    if (logVerbosity != null) { sb.append("logVerbosity:"); sb.append(logVerbosity + ","); }
    if (maxNodeProvisionTime != null) { sb.append("maxNodeProvisionTime:"); sb.append(maxNodeProvisionTime + ","); }
    if (maxPodGracePeriod != null) { sb.append("maxPodGracePeriod:"); sb.append(maxPodGracePeriod + ","); }
    if (podPriorityThreshold != null) { sb.append("podPriorityThreshold:"); sb.append(podPriorityThreshold + ","); }
    if (resourceLimits != null) { sb.append("resourceLimits:"); sb.append(resourceLimits + ","); }
    if (scaleDown != null) { sb.append("scaleDown:"); sb.append(scaleDown + ","); }
    if (skipNodesWithLocalStorage != null) { sb.append("skipNodesWithLocalStorage:"); sb.append(skipNodesWithLocalStorage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withBalanceSimilarNodeGroups() {
    return withBalanceSimilarNodeGroups(true);
  }
  
  public A withIgnoreDaemonsetsUtilization() {
    return withIgnoreDaemonsetsUtilization(true);
  }
  
  public A withSkipNodesWithLocalStorage() {
    return withSkipNodesWithLocalStorage(true);
  }
  public class ResourceLimitsNested<N> extends ResourceLimitsFluent<ResourceLimitsNested<N>> implements Nested<N>{
    ResourceLimitsNested(ResourceLimits item) {
      this.builder = new ResourceLimitsBuilder(this, item);
    }
    ResourceLimitsBuilder builder;
    
    public N and() {
      return (N) ClusterAutoscalerSpecFluent.this.withResourceLimits(builder.build());
    }
    
    public N endResourceLimits() {
      return and();
    }
    
  
  }
  public class ScaleDownNested<N> extends ScaleDownConfigFluent<ScaleDownNested<N>> implements Nested<N>{
    ScaleDownNested(ScaleDownConfig item) {
      this.builder = new ScaleDownConfigBuilder(this, item);
    }
    ScaleDownConfigBuilder builder;
    
    public N and() {
      return (N) ClusterAutoscalerSpecFluent.this.withScaleDown(builder.build());
    }
    
    public N endScaleDown() {
      return and();
    }
    
  
  }

}