/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpec;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecResourceLimits;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecResourceLimitsBuilder;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecResourceLimitsFluent;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecScaleDown;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecScaleDownBuilder;
import io.fabric8.openshift.api.model.autoscaling.v1.ClusterAutoscalerSpecScaleDownFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterAutoscalerSpecFluent<A extends ClusterAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean balanceSimilarNodeGroups;
    private List<String> balancingIgnoredLabels = new ArrayList<String>();
    private List<String> expanders = new ArrayList<String>();
    private Boolean ignoreDaemonsetsUtilization;
    private Integer logVerbosity;
    private String maxNodeProvisionTime;
    private Integer maxPodGracePeriod;
    private Integer podPriorityThreshold;
    private ClusterAutoscalerSpecResourceLimitsBuilder resourceLimits;
    private ClusterAutoscalerSpecScaleDownBuilder scaleDown;
    private Boolean skipNodesWithLocalStorage;
    private Map<String, Object> additionalProperties;

    public ClusterAutoscalerSpecFluent() {
    }

    public ClusterAutoscalerSpecFluent(ClusterAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterAutoscalerSpec instance) {
        ClusterAutoscalerSpec clusterAutoscalerSpec = instance = instance != null ? instance : new ClusterAutoscalerSpec();
        if (instance != null) {
            this.withBalanceSimilarNodeGroups(instance.getBalanceSimilarNodeGroups());
            this.withBalancingIgnoredLabels(instance.getBalancingIgnoredLabels());
            this.withExpanders(instance.getExpanders());
            this.withIgnoreDaemonsetsUtilization(instance.getIgnoreDaemonsetsUtilization());
            this.withLogVerbosity(instance.getLogVerbosity());
            this.withMaxNodeProvisionTime(instance.getMaxNodeProvisionTime());
            this.withMaxPodGracePeriod(instance.getMaxPodGracePeriod());
            this.withPodPriorityThreshold(instance.getPodPriorityThreshold());
            this.withResourceLimits(instance.getResourceLimits());
            this.withScaleDown(instance.getScaleDown());
            this.withSkipNodesWithLocalStorage(instance.getSkipNodesWithLocalStorage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getBalanceSimilarNodeGroups() {
        return this.balanceSimilarNodeGroups;
    }

    public A withBalanceSimilarNodeGroups(Boolean balanceSimilarNodeGroups) {
        this.balanceSimilarNodeGroups = balanceSimilarNodeGroups;
        return (A)((Object)this);
    }

    public boolean hasBalanceSimilarNodeGroups() {
        return this.balanceSimilarNodeGroups != null;
    }

    public A addToBalancingIgnoredLabels(int index, String item) {
        if (this.balancingIgnoredLabels == null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
        }
        this.balancingIgnoredLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToBalancingIgnoredLabels(int index, String item) {
        if (this.balancingIgnoredLabels == null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
        }
        this.balancingIgnoredLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToBalancingIgnoredLabels(String ... items) {
        if (this.balancingIgnoredLabels == null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.balancingIgnoredLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToBalancingIgnoredLabels(Collection<String> items) {
        if (this.balancingIgnoredLabels == null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.balancingIgnoredLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromBalancingIgnoredLabels(String ... items) {
        if (this.balancingIgnoredLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.balancingIgnoredLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromBalancingIgnoredLabels(Collection<String> items) {
        if (this.balancingIgnoredLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.balancingIgnoredLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getBalancingIgnoredLabels() {
        return this.balancingIgnoredLabels;
    }

    public String getBalancingIgnoredLabel(int index) {
        return this.balancingIgnoredLabels.get(index);
    }

    public String getFirstBalancingIgnoredLabel() {
        return this.balancingIgnoredLabels.get(0);
    }

    public String getLastBalancingIgnoredLabel() {
        return this.balancingIgnoredLabels.get(this.balancingIgnoredLabels.size() - 1);
    }

    public String getMatchingBalancingIgnoredLabel(Predicate<String> predicate) {
        for (String item : this.balancingIgnoredLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingBalancingIgnoredLabel(Predicate<String> predicate) {
        for (String item : this.balancingIgnoredLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withBalancingIgnoredLabels(List<String> balancingIgnoredLabels) {
        if (balancingIgnoredLabels != null) {
            this.balancingIgnoredLabels = new ArrayList<String>();
            for (String item : balancingIgnoredLabels) {
                this.addToBalancingIgnoredLabels(item);
            }
        } else {
            this.balancingIgnoredLabels = null;
        }
        return (A)((Object)this);
    }

    public A withBalancingIgnoredLabels(String ... balancingIgnoredLabels) {
        if (this.balancingIgnoredLabels != null) {
            this.balancingIgnoredLabels.clear();
            this._visitables.remove((Object)"balancingIgnoredLabels");
        }
        if (balancingIgnoredLabels != null) {
            for (String item : balancingIgnoredLabels) {
                this.addToBalancingIgnoredLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasBalancingIgnoredLabels() {
        return this.balancingIgnoredLabels != null && !this.balancingIgnoredLabels.isEmpty();
    }

    public A addToExpanders(int index, String item) {
        if (this.expanders == null) {
            this.expanders = new ArrayList<String>();
        }
        this.expanders.add(index, item);
        return (A)((Object)this);
    }

    public A setToExpanders(int index, String item) {
        if (this.expanders == null) {
            this.expanders = new ArrayList<String>();
        }
        this.expanders.set(index, item);
        return (A)((Object)this);
    }

    public A addToExpanders(String ... items) {
        if (this.expanders == null) {
            this.expanders = new ArrayList<String>();
        }
        for (String item : items) {
            this.expanders.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExpanders(Collection<String> items) {
        if (this.expanders == null) {
            this.expanders = new ArrayList<String>();
        }
        for (String item : items) {
            this.expanders.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExpanders(String ... items) {
        if (this.expanders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.expanders.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExpanders(Collection<String> items) {
        if (this.expanders == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.expanders.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExpanders() {
        return this.expanders;
    }

    public String getExpander(int index) {
        return this.expanders.get(index);
    }

    public String getFirstExpander() {
        return this.expanders.get(0);
    }

    public String getLastExpander() {
        return this.expanders.get(this.expanders.size() - 1);
    }

    public String getMatchingExpander(Predicate<String> predicate) {
        for (String item : this.expanders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExpander(Predicate<String> predicate) {
        for (String item : this.expanders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExpanders(List<String> expanders) {
        if (expanders != null) {
            this.expanders = new ArrayList<String>();
            for (String item : expanders) {
                this.addToExpanders(item);
            }
        } else {
            this.expanders = null;
        }
        return (A)((Object)this);
    }

    public A withExpanders(String ... expanders) {
        if (this.expanders != null) {
            this.expanders.clear();
            this._visitables.remove((Object)"expanders");
        }
        if (expanders != null) {
            for (String item : expanders) {
                this.addToExpanders(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExpanders() {
        return this.expanders != null && !this.expanders.isEmpty();
    }

    public Boolean getIgnoreDaemonsetsUtilization() {
        return this.ignoreDaemonsetsUtilization;
    }

    public A withIgnoreDaemonsetsUtilization(Boolean ignoreDaemonsetsUtilization) {
        this.ignoreDaemonsetsUtilization = ignoreDaemonsetsUtilization;
        return (A)((Object)this);
    }

    public boolean hasIgnoreDaemonsetsUtilization() {
        return this.ignoreDaemonsetsUtilization != null;
    }

    public Integer getLogVerbosity() {
        return this.logVerbosity;
    }

    public A withLogVerbosity(Integer logVerbosity) {
        this.logVerbosity = logVerbosity;
        return (A)((Object)this);
    }

    public boolean hasLogVerbosity() {
        return this.logVerbosity != null;
    }

    public String getMaxNodeProvisionTime() {
        return this.maxNodeProvisionTime;
    }

    public A withMaxNodeProvisionTime(String maxNodeProvisionTime) {
        this.maxNodeProvisionTime = maxNodeProvisionTime;
        return (A)((Object)this);
    }

    public boolean hasMaxNodeProvisionTime() {
        return this.maxNodeProvisionTime != null;
    }

    public Integer getMaxPodGracePeriod() {
        return this.maxPodGracePeriod;
    }

    public A withMaxPodGracePeriod(Integer maxPodGracePeriod) {
        this.maxPodGracePeriod = maxPodGracePeriod;
        return (A)((Object)this);
    }

    public boolean hasMaxPodGracePeriod() {
        return this.maxPodGracePeriod != null;
    }

    public Integer getPodPriorityThreshold() {
        return this.podPriorityThreshold;
    }

    public A withPodPriorityThreshold(Integer podPriorityThreshold) {
        this.podPriorityThreshold = podPriorityThreshold;
        return (A)((Object)this);
    }

    public boolean hasPodPriorityThreshold() {
        return this.podPriorityThreshold != null;
    }

    public ClusterAutoscalerSpecResourceLimits buildResourceLimits() {
        return this.resourceLimits != null ? this.resourceLimits.build() : null;
    }

    public A withResourceLimits(ClusterAutoscalerSpecResourceLimits resourceLimits) {
        this._visitables.remove((Object)"resourceLimits");
        if (resourceLimits != null) {
            this.resourceLimits = new ClusterAutoscalerSpecResourceLimitsBuilder(resourceLimits);
            this._visitables.get((Object)"resourceLimits").add(this.resourceLimits);
        } else {
            this.resourceLimits = null;
            this._visitables.get((Object)"resourceLimits").remove((Object)this.resourceLimits);
        }
        return (A)((Object)this);
    }

    public boolean hasResourceLimits() {
        return this.resourceLimits != null;
    }

    public ResourceLimitsNested<A> withNewResourceLimits() {
        return new ResourceLimitsNested(null);
    }

    public ResourceLimitsNested<A> withNewResourceLimitsLike(ClusterAutoscalerSpecResourceLimits item) {
        return new ResourceLimitsNested(item);
    }

    public ResourceLimitsNested<A> editResourceLimits() {
        return this.withNewResourceLimitsLike(Optional.ofNullable(this.buildResourceLimits()).orElse(null));
    }

    public ResourceLimitsNested<A> editOrNewResourceLimits() {
        return this.withNewResourceLimitsLike(Optional.ofNullable(this.buildResourceLimits()).orElse(new ClusterAutoscalerSpecResourceLimitsBuilder().build()));
    }

    public ResourceLimitsNested<A> editOrNewResourceLimitsLike(ClusterAutoscalerSpecResourceLimits item) {
        return this.withNewResourceLimitsLike(Optional.ofNullable(this.buildResourceLimits()).orElse(item));
    }

    public ClusterAutoscalerSpecScaleDown buildScaleDown() {
        return this.scaleDown != null ? this.scaleDown.build() : null;
    }

    public A withScaleDown(ClusterAutoscalerSpecScaleDown scaleDown) {
        this._visitables.remove((Object)"scaleDown");
        if (scaleDown != null) {
            this.scaleDown = new ClusterAutoscalerSpecScaleDownBuilder(scaleDown);
            this._visitables.get((Object)"scaleDown").add(this.scaleDown);
        } else {
            this.scaleDown = null;
            this._visitables.get((Object)"scaleDown").remove((Object)this.scaleDown);
        }
        return (A)((Object)this);
    }

    public boolean hasScaleDown() {
        return this.scaleDown != null;
    }

    public ScaleDownNested<A> withNewScaleDown() {
        return new ScaleDownNested(null);
    }

    public ScaleDownNested<A> withNewScaleDownLike(ClusterAutoscalerSpecScaleDown item) {
        return new ScaleDownNested(item);
    }

    public ScaleDownNested<A> editScaleDown() {
        return this.withNewScaleDownLike(Optional.ofNullable(this.buildScaleDown()).orElse(null));
    }

    public ScaleDownNested<A> editOrNewScaleDown() {
        return this.withNewScaleDownLike(Optional.ofNullable(this.buildScaleDown()).orElse(new ClusterAutoscalerSpecScaleDownBuilder().build()));
    }

    public ScaleDownNested<A> editOrNewScaleDownLike(ClusterAutoscalerSpecScaleDown item) {
        return this.withNewScaleDownLike(Optional.ofNullable(this.buildScaleDown()).orElse(item));
    }

    public Boolean getSkipNodesWithLocalStorage() {
        return this.skipNodesWithLocalStorage;
    }

    public A withSkipNodesWithLocalStorage(Boolean skipNodesWithLocalStorage) {
        this.skipNodesWithLocalStorage = skipNodesWithLocalStorage;
        return (A)((Object)this);
    }

    public boolean hasSkipNodesWithLocalStorage() {
        return this.skipNodesWithLocalStorage != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterAutoscalerSpecFluent that = (ClusterAutoscalerSpecFluent)((Object)o);
        if (!Objects.equals(this.balanceSimilarNodeGroups, that.balanceSimilarNodeGroups)) {
            return false;
        }
        if (!Objects.equals(this.balancingIgnoredLabels, that.balancingIgnoredLabels)) {
            return false;
        }
        if (!Objects.equals(this.expanders, that.expanders)) {
            return false;
        }
        if (!Objects.equals(this.ignoreDaemonsetsUtilization, that.ignoreDaemonsetsUtilization)) {
            return false;
        }
        if (!Objects.equals(this.logVerbosity, that.logVerbosity)) {
            return false;
        }
        if (!Objects.equals(this.maxNodeProvisionTime, that.maxNodeProvisionTime)) {
            return false;
        }
        if (!Objects.equals(this.maxPodGracePeriod, that.maxPodGracePeriod)) {
            return false;
        }
        if (!Objects.equals(this.podPriorityThreshold, that.podPriorityThreshold)) {
            return false;
        }
        if (!Objects.equals((Object)this.resourceLimits, (Object)that.resourceLimits)) {
            return false;
        }
        if (!Objects.equals((Object)this.scaleDown, (Object)that.scaleDown)) {
            return false;
        }
        if (!Objects.equals(this.skipNodesWithLocalStorage, that.skipNodesWithLocalStorage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balanceSimilarNodeGroups, this.balancingIgnoredLabels, this.expanders, this.ignoreDaemonsetsUtilization, this.logVerbosity, this.maxNodeProvisionTime, this.maxPodGracePeriod, this.podPriorityThreshold, this.resourceLimits, this.scaleDown, this.skipNodesWithLocalStorage, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.balanceSimilarNodeGroups != null) {
            sb.append("balanceSimilarNodeGroups:");
            sb.append(this.balanceSimilarNodeGroups + ",");
        }
        if (this.balancingIgnoredLabels != null && !this.balancingIgnoredLabels.isEmpty()) {
            sb.append("balancingIgnoredLabels:");
            sb.append(String.valueOf(this.balancingIgnoredLabels) + ",");
        }
        if (this.expanders != null && !this.expanders.isEmpty()) {
            sb.append("expanders:");
            sb.append(String.valueOf(this.expanders) + ",");
        }
        if (this.ignoreDaemonsetsUtilization != null) {
            sb.append("ignoreDaemonsetsUtilization:");
            sb.append(this.ignoreDaemonsetsUtilization + ",");
        }
        if (this.logVerbosity != null) {
            sb.append("logVerbosity:");
            sb.append(this.logVerbosity + ",");
        }
        if (this.maxNodeProvisionTime != null) {
            sb.append("maxNodeProvisionTime:");
            sb.append(this.maxNodeProvisionTime + ",");
        }
        if (this.maxPodGracePeriod != null) {
            sb.append("maxPodGracePeriod:");
            sb.append(this.maxPodGracePeriod + ",");
        }
        if (this.podPriorityThreshold != null) {
            sb.append("podPriorityThreshold:");
            sb.append(this.podPriorityThreshold + ",");
        }
        if (this.resourceLimits != null) {
            sb.append("resourceLimits:");
            sb.append(String.valueOf((Object)this.resourceLimits) + ",");
        }
        if (this.scaleDown != null) {
            sb.append("scaleDown:");
            sb.append(String.valueOf((Object)this.scaleDown) + ",");
        }
        if (this.skipNodesWithLocalStorage != null) {
            sb.append("skipNodesWithLocalStorage:");
            sb.append(this.skipNodesWithLocalStorage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withBalanceSimilarNodeGroups() {
        return this.withBalanceSimilarNodeGroups(true);
    }

    public A withIgnoreDaemonsetsUtilization() {
        return this.withIgnoreDaemonsetsUtilization(true);
    }

    public A withSkipNodesWithLocalStorage() {
        return this.withSkipNodesWithLocalStorage(true);
    }

    public class ScaleDownNested<N>
    extends ClusterAutoscalerSpecScaleDownFluent<ScaleDownNested<N>>
    implements Nested<N> {
        ClusterAutoscalerSpecScaleDownBuilder builder;

        ScaleDownNested(ClusterAutoscalerSpecScaleDown item) {
            this.builder = new ClusterAutoscalerSpecScaleDownBuilder(this, item);
        }

        public N and() {
            return (N)ClusterAutoscalerSpecFluent.this.withScaleDown(this.builder.build());
        }

        public N endScaleDown() {
            return this.and();
        }
    }

    public class ResourceLimitsNested<N>
    extends ClusterAutoscalerSpecResourceLimitsFluent<ResourceLimitsNested<N>>
    implements Nested<N> {
        ClusterAutoscalerSpecResourceLimitsBuilder builder;

        ResourceLimitsNested(ClusterAutoscalerSpecResourceLimits item) {
            this.builder = new ClusterAutoscalerSpecResourceLimitsBuilder(this, item);
        }

        public N and() {
            return (N)ClusterAutoscalerSpecFluent.this.withResourceLimits(this.builder.build());
        }

        public N endResourceLimits() {
            return this.and();
        }
    }
}

