/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver;

import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.MockServer;
import io.fabric8.mockwebserver.MockWebServer;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.http.Dispatcher;
import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.internal.MockDispatcher;
import io.fabric8.mockwebserver.internal.MockServerExpectationImpl;
import io.vertx.core.net.SelfSignedCertificate;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultMockServer
implements MockServer {
    private final Context context;
    private final boolean useHttps;
    private final MockWebServer server;
    private final Map<ServerRequest, Queue<ServerResponse>> responses;
    private final AtomicInteger lastRequestCount;
    private final AtomicReference<RecordedRequest> lastRequest;
    private final AtomicBoolean initialized = new AtomicBoolean();
    private final AtomicBoolean shutdown = new AtomicBoolean();

    public DefaultMockServer() {
        this(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), false);
    }

    public DefaultMockServer(boolean useHttps) {
        this(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), useHttps);
    }

    public DefaultMockServer(MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this(new Context(), server, responses, useHttps);
    }

    public DefaultMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, boolean useHttps) {
        this(context, server, responses, new MockDispatcher(responses), useHttps);
    }

    public DefaultMockServer(Context context, MockWebServer server, Map<ServerRequest, Queue<ServerResponse>> responses, Dispatcher dispatcher, boolean useHttps) {
        this.context = context;
        this.useHttps = useHttps;
        this.server = server;
        this.responses = responses;
        this.lastRequest = new AtomicReference();
        this.lastRequestCount = new AtomicInteger(0);
        this.server.setDispatcher(dispatcher);
    }

    private void startInternal() {
        if (this.initialized.compareAndSet(false, true)) {
            if (this.useHttps) {
                this.server.useHttps();
            }
            this.onStart();
        }
    }

    private void shutdownInternal() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.onShutdown();
        }
    }

    public final void start() {
        this.startInternal();
        this.server.start();
    }

    public final void start(int port) {
        this.startInternal();
        this.server.start(port);
    }

    public final void start(InetAddress inetAddress, int port) {
        this.startInternal();
        this.server.start(inetAddress, port);
    }

    public final void shutdown() {
        try {
            this.server.shutdown();
        }
        finally {
            this.shutdownInternal();
        }
    }

    public void reset() {
        this.server.reset();
        this.responses.clear();
        this.lastRequest.set(null);
        this.lastRequestCount.set(0);
    }

    @Override
    public String url(String path) {
        return this.server.url(path).toString();
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public String getHostName() {
        return this.server.getHostName();
    }

    @Override
    public Proxy toProxyAddress() {
        return this.server.toProxyAddress();
    }

    @Override
    public SelfSignedCertificate getSelfSignedCertificate() {
        return this.server.getSelfSignedCertificate();
    }

    @Override
    public MockServerExpectation expect() {
        return new MockServerExpectationImpl(this.responses, this.context);
    }

    @Override
    public int getRequestCount() {
        return this.server.getRequestCount();
    }

    @Override
    public RecordedRequest takeRequest() throws InterruptedException {
        return this.server.takeRequest();
    }

    @Override
    public RecordedRequest takeRequest(long timeout, TimeUnit unit) throws InterruptedException {
        return this.server.takeRequest(timeout, unit);
    }

    @Override
    public synchronized RecordedRequest getLastRequest() throws InterruptedException {
        if (this.lastRequest.get() != null && this.getRequestCount() == this.lastRequestCount.get()) {
            return this.lastRequest.get();
        }
        int requestCount = this.getRequestCount() - this.lastRequestCount.getAndSet(this.getRequestCount());
        RecordedRequest latestRequest = null;
        while (requestCount-- > 0) {
            latestRequest = this.takeRequest();
        }
        this.lastRequest.set(latestRequest);
        return latestRequest;
    }
}

