/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaType {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    private final String mediaType;
    private final String type;
    private final String subtype;
    private final String charset;

    public MediaType(String mediaType, String type, String subtype, String charset) {
        this.mediaType = mediaType;
        this.type = type;
        this.subtype = subtype;
        this.charset = charset;
    }

    public static MediaType get(String mediaType) {
        Matcher typeSubtype = TYPE_SUBTYPE.matcher(mediaType);
        if (!typeSubtype.lookingAt()) {
            throw new IllegalArgumentException("No subtype found for: \"" + mediaType + "\"");
        }
        String type = typeSubtype.group(1).toLowerCase(Locale.US);
        String subtype = typeSubtype.group(2).toLowerCase(Locale.US);
        String charset = null;
        Matcher parameter = PARAMETER.matcher(mediaType);
        int s = typeSubtype.end();
        while (s < mediaType.length()) {
            parameter.region(s, mediaType.length());
            if (!parameter.lookingAt()) {
                throw new IllegalArgumentException("Parameter is not formatted correctly: \"" + mediaType.substring(s) + "\" for: \"" + mediaType + "\"");
            }
            String name = parameter.group(1);
            if (name != null && name.equalsIgnoreCase("charset")) {
                String currentCharset = MediaType.extractCharset(parameter.group(2), parameter.group(3));
                if (charset != null && !currentCharset.equalsIgnoreCase(charset)) {
                    throw new IllegalArgumentException("Multiple charsets defined: \"" + charset + "\" and: \"" + currentCharset + "\" for: \"" + mediaType + "\"");
                }
                charset = currentCharset;
            }
            s = parameter.end();
        }
        return new MediaType(mediaType, type, subtype, charset);
    }

    private static String extractCharset(String token, String quoted) {
        String charsetParameter = token != null ? (token.startsWith("'") && token.endsWith("'") && token.length() > 2 ? token.substring(1, token.length() - 1) : token) : quoted;
        return charsetParameter;
    }

    public static MediaType parse(String string) {
        try {
            return MediaType.get(string);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public final String type() {
        return this.type;
    }

    public final String subtype() {
        return this.subtype;
    }

    public final String charset() {
        return this.charset;
    }

    public final String toString() {
        return this.mediaType;
    }
}

