/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.utils;

import io.fabric8.mockwebserver.http.Headers;
import io.fabric8.mockwebserver.http.RecordedRequest;
import io.fabric8.mockwebserver.utils.BodyProvider;
import io.fabric8.mockwebserver.utils.ResponseProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ResponseProviders {
    private ResponseProviders() {
    }

    public static <R> ResponseProvider<R> of(int statusCode, R element) {
        if (element != null) {
            return new FixedResponseProvider<R>(statusCode, element);
        }
        return null;
    }

    public static <R> ResponseProvider<R> of(int statusCode, R element, Map<String, String> map) {
        if (element != null) {
            return new FixedResponseProvider<R>(statusCode, element, map);
        }
        return null;
    }

    public static <R> ResponseProvider<List<R>> ofAll(int statusCode, R ... elements) {
        if (elements != null) {
            return new FixedResponseProvider<List<R>>(statusCode, Arrays.asList(elements));
        }
        return null;
    }

    public static <R> ResponseProvider<R> of(final int statusCode, final BodyProvider<R> bodyProvider) {
        if (bodyProvider != null) {
            return new ResponseProvider<R>(){
                private Headers headers = new Headers.Builder().build();

                @Override
                public int getStatusCode(RecordedRequest request) {
                    return statusCode;
                }

                @Override
                public R getBody(RecordedRequest request) {
                    return bodyProvider.getBody(request);
                }

                @Override
                public Headers getHeaders() {
                    return this.headers;
                }

                @Override
                public void setHeaders(Headers headers) {
                    this.headers = headers;
                }
            };
        }
        return null;
    }

    private static class FixedResponseProvider<T>
    implements ResponseProvider<T> {
        private final int statusCode;
        private final T element;
        private Headers headers;

        public FixedResponseProvider(int statusCode, T element) {
            this(statusCode, element, Collections.emptyMap());
        }

        public FixedResponseProvider(int statusCode, T element, Map<String, String> headers) {
            this(statusCode, element, FixedResponseProvider.toHeaders(headers));
        }

        public FixedResponseProvider(int statusCode, T element, Headers headers) {
            this.statusCode = statusCode;
            this.element = element;
            this.headers = headers;
        }

        @Override
        public T getBody(RecordedRequest request) {
            return this.element;
        }

        @Override
        public int getStatusCode(RecordedRequest request) {
            return this.statusCode;
        }

        @Override
        public Headers getHeaders() {
            return this.headers;
        }

        @Override
        public void setHeaders(Headers headers) {
            this.headers = headers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedResponseProvider that = (FixedResponseProvider)o;
            return this.element != null ? this.element.equals(that.element) : that.element == null;
        }

        public int hashCode() {
            return this.element != null ? this.element.hashCode() : 0;
        }

        private static Headers toHeaders(Map<String, String> headers) {
            Headers.Builder builder = new Headers.Builder();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder.set(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }
    }
}

