/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class Headers {
    private final Map<String, List<String>> headerMap;

    Headers(Map<String, List<String>> headerMap) {
        this.headerMap = headerMap;
    }

    public final List<String> headers(String key) {
        return Collections.unmodifiableList(this.headerMap.getOrDefault(Headers.keySanitize(key), Collections.emptyList()));
    }

    public final String header(String key) {
        List<String> values = this.headers(key);
        if (values.size() == 1) {
            return values.get(0);
        }
        if (values.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", values);
    }

    public final String get(String name) {
        return this.header(name);
    }

    public final Map<String, List<String>> toMultimap() {
        return this.headerMap.entrySet().stream().collect(Collectors.toMap(e -> Headers.keySanitize((String)e.getKey()), Map.Entry::getValue, (old, neu) -> neu));
    }

    private static String keySanitize(String header) {
        return header.trim().toLowerCase(Locale.ROOT);
    }

    public final Builder newBuilder() {
        return new Builder(new LinkedHashMap<String, List<String>>(this.headerMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())))));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, List<String>> headerMap;

        public Builder() {
            this(new LinkedHashMap<String, List<String>>());
        }

        private Builder(Map<String, List<String>> headers) {
            this.headerMap = headers;
        }

        public Headers build() {
            return new Headers(this.headerMap);
        }

        public Builder add(String key, String value) {
            this.headerMap.compute(Headers.keySanitize(key), (k, values) -> {
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(value);
                return values;
            });
            return this;
        }

        public Builder add(String header) {
            int index = header.indexOf(":");
            if (index == -1) {
                throw new IllegalArgumentException("Unexpected header: " + header);
            }
            return this.add(header.substring(0, index).trim(), header.substring(index + 1).trim());
        }

        public Builder addAll(Iterable<Map.Entry<String, String>> headers) {
            for (Map.Entry<String, String> header : headers) {
                this.add(header.getKey(), header.getValue());
            }
            return this;
        }

        public Builder removeAll(String key) {
            this.headerMap.remove(Headers.keySanitize(key));
            return this;
        }

        public Builder set(String name, String value) {
            return this.setHeader(name, value);
        }

        public Builder setHeader(String key, String value) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.headerMap.put(Headers.keySanitize(key), values);
            return this;
        }

        public Builder setHeaders(Headers headers) {
            this.headerMap.clear();
            this.headerMap.putAll(headers.newBuilder().headerMap);
            return this;
        }
    }
}

