/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import io.fabric8.mockwebserver.http.Dispatcher;
import io.fabric8.mockwebserver.http.MockResponse;
import io.fabric8.mockwebserver.http.RecordedRequest;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueueDispatcher
extends Dispatcher {
    private static final MockResponse DEAD_LETTER = new MockResponse().setResponseCode(503);
    private final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<MockResponse>();
    private MockResponse failFastResponse;

    @Override
    public MockResponse dispatch(RecordedRequest request) {
        if (this.failFastResponse != null && this.responseQueue.isEmpty()) {
            return this.failFastResponse;
        }
        try {
            MockResponse ret = this.responseQueue.take();
            if (ret == DEAD_LETTER) {
                this.responseQueue.add(DEAD_LETTER);
            }
            return ret;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for response", e);
        }
    }

    @Override
    public void shutdown() {
        this.responseQueue.add(DEAD_LETTER);
    }

    public final void enqueueResponse(MockResponse response) {
        this.responseQueue.add(response);
    }

    public final QueueDispatcher setFailFastResponse(MockResponse response) {
        this.failFastResponse = response;
        return this;
    }
}

