/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.utils.ResponseProvider;
import io.fabric8.mockwebserver.utils.ResponseProviders;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;

public class ChunkedResponse
implements ServerResponse {
    private static final int DEFAULT_MAX_CHUNK_SIZE = 204800;
    private final ResponseProvider<List<String>> bodyProvider;
    private final boolean repeatable;
    private final long responseDelay;
    private final TimeUnit responseDelayUnit;

    public ChunkedResponse(boolean repeatable, int statusCode, String ... body) {
        this(repeatable, ResponseProviders.ofAll(statusCode, body));
    }

    public ChunkedResponse(boolean repeatable, ResponseProvider<List<String>> bodyProvider) {
        this(repeatable, 0L, TimeUnit.MILLISECONDS, bodyProvider);
    }

    public ChunkedResponse(boolean repeatable, int statusCode, long responseDelay, TimeUnit responseDelayUnit, String ... body) {
        this(repeatable, responseDelay, responseDelayUnit, ResponseProviders.ofAll(statusCode, body));
    }

    public ChunkedResponse(boolean repeatable, long responseDelay, TimeUnit responseDelayUnit, ResponseProvider<List<String>> bodyProvider) {
        this.bodyProvider = bodyProvider;
        this.repeatable = repeatable;
        this.responseDelay = responseDelay;
        this.responseDelayUnit = responseDelayUnit;
    }

    public ResponseProvider<List<String>> getBodyProvider() {
        return this.bodyProvider;
    }

    @Override
    @Deprecated
    public MockResponse toMockResponse() {
        return this.toMockResponse(null);
    }

    @Override
    public MockResponse toMockResponse(RecordedRequest request) {
        MockResponse mockResponse = new MockResponse();
        mockResponse.setHeaders(this.bodyProvider.getHeaders());
        mockResponse.setChunkedBody(this.concatBody(request), 204800);
        mockResponse.setResponseCode(this.bodyProvider.getStatusCode(request));
        if (this.responseDelay > 0L) {
            mockResponse.setBodyDelay(this.responseDelay, this.responseDelayUnit);
        }
        return mockResponse;
    }

    private String concatBody(RecordedRequest request) {
        StringBuilder sb = new StringBuilder();
        for (String s : (List)this.bodyProvider.getBody(request)) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }
}

