/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.utils;

import io.fabric8.mockwebserver.utils.BodyProvider;
import io.fabric8.mockwebserver.utils.ResponseProvider;
import java.util.Arrays;
import java.util.List;
import okhttp3.Headers;
import okhttp3.mockwebserver.RecordedRequest;

public class ResponseProviders {
    public static <R> ResponseProvider<R> of(int statusCode, R element) {
        if (element != null) {
            return new FixedResponseProvider<R>(statusCode, element);
        }
        return null;
    }

    public static <R> ResponseProvider<List<R>> ofAll(int statusCode, R ... elements) {
        if (elements != null) {
            return new FixedResponseProvider<List<R>>(statusCode, Arrays.asList(elements));
        }
        return null;
    }

    public static <R> ResponseProvider<R> of(final int statusCode, final BodyProvider<R> bodyProvider) {
        if (bodyProvider != null) {
            return new ResponseProvider<R>(){
                private Headers headers = new Headers.Builder().build();

                @Override
                public int getStatusCode() {
                    return statusCode;
                }

                @Override
                public R getBody(RecordedRequest request) {
                    return bodyProvider.getBody(request);
                }

                @Override
                public Headers getHeaders() {
                    return this.headers;
                }

                @Override
                public void setHeaders(Headers headers) {
                    this.headers = headers;
                }
            };
        }
        return null;
    }

    private static class FixedResponseProvider<T>
    implements ResponseProvider<T> {
        private int statusCode;
        private T element;
        private Headers headers = new Headers.Builder().build();

        public FixedResponseProvider(int statusCode, T element) {
            this.statusCode = statusCode;
            this.element = element;
        }

        @Override
        public T getBody(RecordedRequest request) {
            return this.element;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public Headers getHeaders() {
            return this.headers;
        }

        @Override
        public void setHeaders(Headers headers) {
            this.headers = headers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedResponseProvider that = (FixedResponseProvider)o;
            return this.element != null ? this.element.equals(that.element) : that.element == null;
        }

        public int hashCode() {
            return this.element != null ? this.element.hashCode() : 0;
        }
    }
}

