/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.crud;

import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;

public class CrudDispatcher
extends Dispatcher {
    private static final String POST = "post";
    private static final String UPDATE = "update";
    private static final String GET = "get";
    private static final String DELETE = "delete";
    protected Map<AttributeSet, String> map = new HashMap<AttributeSet, String>();
    protected final AttributeExtractor attributeExtractor;
    protected final ResponseComposer responseComposer;

    public CrudDispatcher(AttributeExtractor attributeExtractor, ResponseComposer responseComposer) {
        this.attributeExtractor = attributeExtractor;
        this.responseComposer = responseComposer;
    }

    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        String path = request.getPath();
        String method = request.getMethod();
        if (POST.equalsIgnoreCase(method)) {
            return this.handlePost(path, request.getBody().readUtf8());
        }
        if (UPDATE.equalsIgnoreCase(path)) {
            return this.handlePost(path, request.getBody().readUtf8());
        }
        if (GET.equalsIgnoreCase(method)) {
            return this.handleGet(path);
        }
        if (DELETE.equalsIgnoreCase(method)) {
            return this.handleDelete(path);
        }
        return null;
    }

    public MockResponse handlePost(String path, String s) {
        MockResponse response = new MockResponse();
        AttributeSet features = AttributeSet.merge(this.attributeExtractor.fromPath(path), this.attributeExtractor.fromResource(s));
        this.map.put(features, s);
        response.setBody(s);
        response.setResponseCode(202);
        return response;
    }

    public MockResponse handleUpdate(String path, String s) {
        return this.handlePost(path, s);
    }

    public MockResponse handleGet(String path) {
        MockResponse response = new MockResponse();
        ArrayList<String> items = new ArrayList<String>();
        AttributeSet query = this.attributeExtractor.extract(path);
        for (Map.Entry<AttributeSet, String> entry : this.map.entrySet()) {
            if (!entry.getKey().matches(query)) continue;
            items.add(entry.getValue());
        }
        if (!items.isEmpty()) {
            response.setBody(this.responseComposer.compose(items));
            response.setResponseCode(200);
        } else {
            response.setResponseCode(404);
        }
        return response;
    }

    public MockResponse handleDelete(String path) {
        MockResponse response = new MockResponse();
        ArrayList<AttributeSet> items = new ArrayList<AttributeSet>();
        AttributeSet query = this.attributeExtractor.extract(path);
        for (Map.Entry<AttributeSet, String> entry : this.map.entrySet()) {
            if (!entry.getKey().matches(query)) continue;
            items.add(entry.getKey());
        }
        if (!items.isEmpty()) {
            for (AttributeSet item : items) {
                this.map.remove(item);
            }
            response.setResponseCode(200);
        } else {
            response.setResponseCode(404);
        }
        return response;
    }

    public Map<AttributeSet, String> getMap() {
        return this.map;
    }

    public AttributeExtractor getAttributeExtractor() {
        return this.attributeExtractor;
    }

    public ResponseComposer getResponseComposer() {
        return this.responseComposer;
    }
}

