package io.fabric8.kubernetes.api.model.storagemigration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
public class MigrationConditionBuilder extends MigrationConditionFluent<MigrationConditionBuilder> implements VisitableBuilder<MigrationCondition,MigrationConditionBuilder>{

  MigrationConditionFluent<?> fluent;

  public MigrationConditionBuilder() {
    this(new MigrationCondition());
  }
  
  public MigrationConditionBuilder(MigrationConditionFluent<?> fluent) {
    this(fluent, new MigrationCondition());
  }
  
  public MigrationConditionBuilder(MigrationCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  
  public MigrationConditionBuilder(MigrationConditionFluent<?> fluent,MigrationCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }

  public MigrationCondition build() {
    MigrationCondition buildable = new MigrationCondition(fluent.getLastUpdateTime(), fluent.getMessage(), fluent.getReason(), fluent.getStatus(), fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}