package io.fabric8.kubernetes.api.model.storagemigration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StorageVersionMigrationStatusBuilder extends StorageVersionMigrationStatusFluent<StorageVersionMigrationStatusBuilder> implements VisitableBuilder<StorageVersionMigrationStatus,StorageVersionMigrationStatusBuilder>{
  public StorageVersionMigrationStatusBuilder() {
    this(new StorageVersionMigrationStatus());
  }
  
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatusFluent<?> fluent) {
    this(fluent, new StorageVersionMigrationStatus());
  }
  
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatusFluent<?> fluent,StorageVersionMigrationStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StorageVersionMigrationStatusBuilder(StorageVersionMigrationStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StorageVersionMigrationStatusFluent<?> fluent;
  
  public StorageVersionMigrationStatus build() {
    StorageVersionMigrationStatus buildable = new StorageVersionMigrationStatus(fluent.buildConditions(),fluent.getResourceVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}