package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CSIDriverBuilder extends CSIDriverFluent<CSIDriverBuilder> implements VisitableBuilder<CSIDriver,CSIDriverBuilder>{
  public CSIDriverBuilder() {
    this(new CSIDriver());
  }
  
  public CSIDriverBuilder(CSIDriverFluent<?> fluent) {
    this(fluent, new CSIDriver());
  }
  
  public CSIDriverBuilder(CSIDriverFluent<?> fluent,CSIDriver instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CSIDriverBuilder(CSIDriver instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CSIDriverFluent<?> fluent;
  
  public CSIDriver build() {
    CSIDriver buildable = new CSIDriver(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}