package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSINodeListBuilder extends CSINodeListFluent<CSINodeListBuilder> implements VisitableBuilder<CSINodeList,CSINodeListBuilder>{
  public CSINodeListBuilder() {
    this(false);
  }
  public CSINodeListBuilder(Boolean validationEnabled) {
    this(new CSINodeList(), validationEnabled);
  }
  public CSINodeListBuilder(CSINodeListFluent<?> fluent) {
    this(fluent, false);
  }
  public CSINodeListBuilder(CSINodeListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSINodeList(), validationEnabled);
  }
  public CSINodeListBuilder(CSINodeListFluent<?> fluent,CSINodeList instance) {
    this(fluent, instance, false);
  }
  public CSINodeListBuilder(CSINodeListFluent<?> fluent,CSINodeList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CSINodeList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CSINodeListBuilder(CSINodeList instance) {
    this(instance,false);
  }
  public CSINodeListBuilder(CSINodeList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CSINodeList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CSINodeListFluent<?> fluent;
  Boolean validationEnabled;
  public CSINodeList build() {
    CSINodeList buildable = new CSINodeList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}