package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSIDriverListBuilder extends CSIDriverListFluent<CSIDriverListBuilder> implements VisitableBuilder<CSIDriverList,CSIDriverListBuilder>{
  public CSIDriverListBuilder() {
    this(false);
  }
  public CSIDriverListBuilder(Boolean validationEnabled) {
    this(new CSIDriverList(), validationEnabled);
  }
  public CSIDriverListBuilder(CSIDriverListFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIDriverListBuilder(CSIDriverListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSIDriverList(), validationEnabled);
  }
  public CSIDriverListBuilder(CSIDriverListFluent<?> fluent,CSIDriverList instance) {
    this(fluent, instance, false);
  }
  public CSIDriverListBuilder(CSIDriverListFluent<?> fluent,CSIDriverList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CSIDriverList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CSIDriverListBuilder(CSIDriverList instance) {
    this(instance,false);
  }
  public CSIDriverListBuilder(CSIDriverList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CSIDriverList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CSIDriverListFluent<?> fluent;
  Boolean validationEnabled;
  public CSIDriverList build() {
    CSIDriverList buildable = new CSIDriverList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}