package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeAttachmentBuilder extends VolumeAttachmentFluentImpl<VolumeAttachmentBuilder> implements VisitableBuilder<VolumeAttachment,VolumeAttachmentBuilder>{
  public VolumeAttachmentBuilder() {
    this(false);
  }
  public VolumeAttachmentBuilder(Boolean validationEnabled) {
    this(new VolumeAttachment(), validationEnabled);
  }
  public VolumeAttachmentBuilder(VolumeAttachmentFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeAttachmentBuilder(VolumeAttachmentFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeAttachment(), validationEnabled);
  }
  public VolumeAttachmentBuilder(VolumeAttachmentFluent<?> fluent,VolumeAttachment instance) {
    this(fluent, instance, false);
  }
  public VolumeAttachmentBuilder(VolumeAttachmentFluent<?> fluent,VolumeAttachment instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VolumeAttachmentBuilder(VolumeAttachment instance) {
    this(instance,false);
  }
  public VolumeAttachmentBuilder(VolumeAttachment instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VolumeAttachmentFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeAttachment build() {
    VolumeAttachment buildable = new VolumeAttachment(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}