package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeAttachmentStatusBuilder extends VolumeAttachmentStatusFluentImpl<VolumeAttachmentStatusBuilder> implements VisitableBuilder<VolumeAttachmentStatus,VolumeAttachmentStatusBuilder>{
  public VolumeAttachmentStatusBuilder() {
    this(false);
  }
  public VolumeAttachmentStatusBuilder(Boolean validationEnabled) {
    this(new VolumeAttachmentStatus(), validationEnabled);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeAttachmentStatus(), validationEnabled);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,VolumeAttachmentStatus instance) {
    this(fluent, instance, false);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatusFluent<?> fluent,VolumeAttachmentStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAttachError(instance.getAttachError()); 
    fluent.withAttached(instance.getAttached()); 
    fluent.withAttachmentMetadata(instance.getAttachmentMetadata()); 
    fluent.withDetachError(instance.getDetachError()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatus instance) {
    this(instance,false);
  }
  public VolumeAttachmentStatusBuilder(VolumeAttachmentStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAttachError(instance.getAttachError()); 
    this.withAttached(instance.getAttached()); 
    this.withAttachmentMetadata(instance.getAttachmentMetadata()); 
    this.withDetachError(instance.getDetachError()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VolumeAttachmentStatusFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeAttachmentStatus build() {
    VolumeAttachmentStatus buildable = new VolumeAttachmentStatus(fluent.getAttachError(),fluent.getAttached(),fluent.getAttachmentMetadata(),fluent.getDetachError());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}