/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.storage.CSINodeSpec;
import io.fabric8.kubernetes.api.model.storage.CSINodeSpecFluent;
import io.fabric8.kubernetes.api.model.storage.CSINodeSpecFluentImpl;
import java.util.Objects;

public class CSINodeSpecBuilder
extends CSINodeSpecFluentImpl<CSINodeSpecBuilder>
implements VisitableBuilder<CSINodeSpec, CSINodeSpecBuilder> {
    CSINodeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CSINodeSpecBuilder() {
        this(true);
    }

    public CSINodeSpecBuilder(Boolean validationEnabled) {
        this(new CSINodeSpec(), validationEnabled);
    }

    public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CSINodeSpec(), validationEnabled);
    }

    public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent, CSINodeSpec instance) {
        this(fluent, instance, true);
    }

    public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent, CSINodeSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDrivers(instance.getDrivers());
        this.validationEnabled = validationEnabled;
    }

    public CSINodeSpecBuilder(CSINodeSpec instance) {
        this(instance, (Boolean)true);
    }

    public CSINodeSpecBuilder(CSINodeSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDrivers(instance.getDrivers());
        this.validationEnabled = validationEnabled;
    }

    public CSINodeSpec build() {
        CSINodeSpec buildable = new CSINodeSpec(this.fluent.getDrivers());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSINodeSpecBuilder that = (CSINodeSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

