package io.fabric8.kubernetes.api.model.storage;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;

public class VolumeAttachmentSourceFluentImpl<A extends VolumeAttachmentSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VolumeAttachmentSourceFluent<A>{

    private PersistentVolumeSpec inlineVolumeSpec;
    private String persistentVolumeName;

    public VolumeAttachmentSourceFluentImpl(){
    }
    public VolumeAttachmentSourceFluentImpl(VolumeAttachmentSource instance){
            this.withInlineVolumeSpec(instance.getInlineVolumeSpec()); 
            this.withPersistentVolumeName(instance.getPersistentVolumeName()); 
    }

    public PersistentVolumeSpec getInlineVolumeSpec(){
            return this.inlineVolumeSpec;
    }

    public A withInlineVolumeSpec(PersistentVolumeSpec inlineVolumeSpec){
            this.inlineVolumeSpec=inlineVolumeSpec; return (A) this;
    }

    public Boolean hasInlineVolumeSpec(){
            return this.inlineVolumeSpec != null;
    }

    public String getPersistentVolumeName(){
            return this.persistentVolumeName;
    }

    public A withPersistentVolumeName(String persistentVolumeName){
            this.persistentVolumeName=persistentVolumeName; return (A) this;
    }

    public Boolean hasPersistentVolumeName(){
            return this.persistentVolumeName != null;
    }

    public A withNewPersistentVolumeName(String arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public A withNewPersistentVolumeName(StringBuilder arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public A withNewPersistentVolumeName(StringBuffer arg1){
            return (A)withPersistentVolumeName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            VolumeAttachmentSourceFluentImpl that = (VolumeAttachmentSourceFluentImpl) o;
            if (inlineVolumeSpec != null ? !inlineVolumeSpec.equals(that.inlineVolumeSpec) :that.inlineVolumeSpec != null) return false;
            if (persistentVolumeName != null ? !persistentVolumeName.equals(that.persistentVolumeName) :that.persistentVolumeName != null) return false;
            return true;
    }




}
