package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface VolumeAttachmentFluent<A extends VolumeAttachmentFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public VolumeAttachmentFluent.MetadataNested<A> withNewMetadata();
    public VolumeAttachmentFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public VolumeAttachmentFluent.MetadataNested<A> editMetadata();
    public VolumeAttachmentFluent.MetadataNested<A> editOrNewMetadata();
    public VolumeAttachmentFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public VolumeAttachmentSpec getSpec();
    public VolumeAttachmentSpec buildSpec();
    public A withSpec(VolumeAttachmentSpec spec);
    public Boolean hasSpec();
    public VolumeAttachmentFluent.SpecNested<A> withNewSpec();
    public VolumeAttachmentFluent.SpecNested<A> withNewSpecLike(VolumeAttachmentSpec item);
    public VolumeAttachmentFluent.SpecNested<A> editSpec();
    public VolumeAttachmentFluent.SpecNested<A> editOrNewSpec();
    public VolumeAttachmentFluent.SpecNested<A> editOrNewSpecLike(VolumeAttachmentSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public VolumeAttachmentStatus getStatus();
    public VolumeAttachmentStatus buildStatus();
    public A withStatus(VolumeAttachmentStatus status);
    public Boolean hasStatus();
    public VolumeAttachmentFluent.StatusNested<A> withNewStatus();
    public VolumeAttachmentFluent.StatusNested<A> withNewStatusLike(VolumeAttachmentStatus item);
    public VolumeAttachmentFluent.StatusNested<A> editStatus();
    public VolumeAttachmentFluent.StatusNested<A> editOrNewStatus();
    public VolumeAttachmentFluent.StatusNested<A> editOrNewStatusLike(VolumeAttachmentStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<VolumeAttachmentFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeAttachmentSpecFluent<VolumeAttachmentFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeAttachmentStatusFluent<VolumeAttachmentFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
