package io.fabric8.kubernetes.api.model.scheduling.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PriorityClassListFluent<A extends PriorityClassListFluent<A>> extends BaseFluent<A>{
  public PriorityClassListFluent() {
  }
  
  public PriorityClassListFluent(PriorityClassList instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private ArrayList<PriorityClassBuilder> items = new ArrayList<PriorityClassBuilder>();
  private String kind;
  private ListMeta metadata;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PriorityClassList instance) {
    instance = (instance != null ? instance : new PriorityClassList());
  
    if (instance != null) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public A addToItems(int index,PriorityClass item) {
    if (this.items == null) {this.items = new ArrayList<PriorityClassBuilder>();}
    PriorityClassBuilder builder = new PriorityClassBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  
  public A setToItems(int index,PriorityClass item) {
    if (this.items == null) {this.items = new ArrayList<PriorityClassBuilder>();}
    PriorityClassBuilder builder = new PriorityClassBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  
  public A addToItems(io.fabric8.kubernetes.api.model.scheduling.v1beta1.PriorityClass... items) {
    if (this.items == null) {this.items = new ArrayList<PriorityClassBuilder>();}
    for (PriorityClass item : items) {PriorityClassBuilder builder = new PriorityClassBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A addAllToItems(Collection<PriorityClass> items) {
    if (this.items == null) {this.items = new ArrayList<PriorityClassBuilder>();}
    for (PriorityClass item : items) {PriorityClassBuilder builder = new PriorityClassBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  
  public A removeFromItems(io.fabric8.kubernetes.api.model.scheduling.v1beta1.PriorityClass... items) {
    if (this.items == null) return (A)this;
    for (PriorityClass item : items) {PriorityClassBuilder builder = new PriorityClassBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeAllFromItems(Collection<PriorityClass> items) {
    if (this.items == null) return (A)this;
    for (PriorityClass item : items) {PriorityClassBuilder builder = new PriorityClassBuilder(item);_visitables.get("items").remove(builder); this.items.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromItems(Predicate<PriorityClassBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<PriorityClassBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      PriorityClassBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PriorityClass> buildItems() {
    return items != null ? build(items) : null;
  }
  
  public PriorityClass buildItem(int index) {
    return this.items.get(index).build();
  }
  
  public PriorityClass buildFirstItem() {
    return this.items.get(0).build();
  }
  
  public PriorityClass buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  
  public PriorityClass buildMatchingItem(Predicate<PriorityClassBuilder> predicate) {
    for (PriorityClassBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingItem(Predicate<PriorityClassBuilder> predicate) {
    for (PriorityClassBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withItems(List<PriorityClass> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (PriorityClass item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  
  public A withItems(io.fabric8.kubernetes.api.model.scheduling.v1beta1.PriorityClass... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (PriorityClass item :items){ this.addToItems(item);}} return (A) this;
  }
  
  public boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  
  public ItemsNested<A> addNewItem() {
    return new ItemsNested(-1, null);
  }
  
  public ItemsNested<A> addNewItemLike(PriorityClass item) {
    return new ItemsNested(-1, item);
  }
  
  public ItemsNested<A> setNewItemLike(int index,PriorityClass item) {
    return new ItemsNested(index, item);
  }
  
  public ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  
  public ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public ItemsNested<A> editMatchingItem(Predicate<PriorityClassBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ListMeta getMetadata() {
    return this.metadata;
  }
  
  public A withMetadata(ListMeta metadata) {
    this.metadata=metadata; return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PriorityClassListFluent that = (PriorityClassListFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
  
    if (!java.util.Objects.equals(items, that.items)) return false;
  
    if (!java.util.Objects.equals(kind, that.kind)) return false;
  
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ItemsNested<N> extends PriorityClassFluent<ItemsNested<N>> implements Nested<N>{
    ItemsNested(int index,PriorityClass item) {
      this.index = index;
      this.builder = new PriorityClassBuilder(this, item);
    }
    PriorityClassBuilder builder;
    int index;
    
    public N and() {
      return (N) PriorityClassListFluent.this.setToItems(index,builder.build());
    }
    
    public N endItem() {
      return and();
    }
    
  
  }

}