package io.fabric8.kubernetes.api.model.resource.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ExactDeviceRequestBuilder extends ExactDeviceRequestFluent<ExactDeviceRequestBuilder> implements VisitableBuilder<ExactDeviceRequest,ExactDeviceRequestBuilder>{
  public ExactDeviceRequestBuilder() {
    this(new ExactDeviceRequest());
  }
  
  public ExactDeviceRequestBuilder(ExactDeviceRequestFluent<?> fluent) {
    this(fluent, new ExactDeviceRequest());
  }
  
  public ExactDeviceRequestBuilder(ExactDeviceRequestFluent<?> fluent,ExactDeviceRequest instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ExactDeviceRequestBuilder(ExactDeviceRequest instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ExactDeviceRequestFluent<?> fluent;
  
  public ExactDeviceRequest build() {
    ExactDeviceRequest buildable = new ExactDeviceRequest(fluent.getAdminAccess(),fluent.getAllocationMode(),fluent.getCount(),fluent.getDeviceClassName(),fluent.buildSelectors(),fluent.buildTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}