package io.fabric8.kubernetes.api.model.resource.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeviceTolerationBuilder extends DeviceTolerationFluent<DeviceTolerationBuilder> implements VisitableBuilder<DeviceToleration,DeviceTolerationBuilder>{
  public DeviceTolerationBuilder() {
    this(new DeviceToleration());
  }
  
  public DeviceTolerationBuilder(DeviceTolerationFluent<?> fluent) {
    this(fluent, new DeviceToleration());
  }
  
  public DeviceTolerationBuilder(DeviceTolerationFluent<?> fluent,DeviceToleration instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeviceTolerationBuilder(DeviceToleration instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeviceTolerationFluent<?> fluent;
  
  public DeviceToleration build() {
    DeviceToleration buildable = new DeviceToleration(fluent.getEffect(),fluent.getKey(),fluent.getOperator(),fluent.getTolerationSeconds(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}