package io.fabric8.kubernetes.api.model.resource.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AllocatedDeviceStatusBuilder extends AllocatedDeviceStatusFluent<AllocatedDeviceStatusBuilder> implements VisitableBuilder<AllocatedDeviceStatus,AllocatedDeviceStatusBuilder>{
  public AllocatedDeviceStatusBuilder() {
    this(new AllocatedDeviceStatus());
  }
  
  public AllocatedDeviceStatusBuilder(AllocatedDeviceStatusFluent<?> fluent) {
    this(fluent, new AllocatedDeviceStatus());
  }
  
  public AllocatedDeviceStatusBuilder(AllocatedDeviceStatusFluent<?> fluent,AllocatedDeviceStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AllocatedDeviceStatusBuilder(AllocatedDeviceStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AllocatedDeviceStatusFluent<?> fluent;
  
  public AllocatedDeviceStatus build() {
    AllocatedDeviceStatus buildable = new AllocatedDeviceStatus(fluent.getConditions(),fluent.getData(),fluent.getDevice(),fluent.getDriver(),fluent.buildNetworkData(),fluent.getPool());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}