package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.NodeSelector;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceSliceSpecFluent<A extends ResourceSliceSpecFluent<A>> extends BaseFluent<A>{
  public ResourceSliceSpecFluent() {
  }
  
  public ResourceSliceSpecFluent(ResourceSliceSpec instance) {
    this.copyInstance(instance);
  }
  private Boolean allNodes;
  private ArrayList<DeviceBuilder> devices = new ArrayList<DeviceBuilder>();
  private String driver;
  private String nodeName;
  private NodeSelector nodeSelector;
  private Boolean perDeviceNodeSelection;
  private ResourcePoolBuilder pool;
  private ArrayList<CounterSetBuilder> sharedCounters = new ArrayList<CounterSetBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceSliceSpec instance) {
    instance = (instance != null ? instance : new ResourceSliceSpec());
    if (instance != null) {
          this.withAllNodes(instance.getAllNodes());
          this.withDevices(instance.getDevices());
          this.withDriver(instance.getDriver());
          this.withNodeName(instance.getNodeName());
          this.withNodeSelector(instance.getNodeSelector());
          this.withPerDeviceNodeSelection(instance.getPerDeviceNodeSelection());
          this.withPool(instance.getPool());
          this.withSharedCounters(instance.getSharedCounters());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getAllNodes() {
    return this.allNodes;
  }
  
  public A withAllNodes(Boolean allNodes) {
    this.allNodes = allNodes;
    return (A) this;
  }
  
  public boolean hasAllNodes() {
    return this.allNodes != null;
  }
  
  public A addToDevices(int index,Device item) {
    if (this.devices == null) {this.devices = new ArrayList<DeviceBuilder>();}
    DeviceBuilder builder = new DeviceBuilder(item);
    if (index < 0 || index >= devices.size()) {
        _visitables.get("devices").add(builder);
        devices.add(builder);
    } else {
        _visitables.get("devices").add(builder);
        devices.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToDevices(int index,Device item) {
    if (this.devices == null) {this.devices = new ArrayList<DeviceBuilder>();}
    DeviceBuilder builder = new DeviceBuilder(item);
    if (index < 0 || index >= devices.size()) {
        _visitables.get("devices").add(builder);
        devices.add(builder);
    } else {
        _visitables.get("devices").add(builder);
        devices.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToDevices(io.fabric8.kubernetes.api.model.resource.v1beta1.Device... items) {
    if (this.devices == null) {this.devices = new ArrayList<DeviceBuilder>();}
    for (Device item : items) {DeviceBuilder builder = new DeviceBuilder(item);_visitables.get("devices").add(builder);this.devices.add(builder);} return (A)this;
  }
  
  public A addAllToDevices(Collection<Device> items) {
    if (this.devices == null) {this.devices = new ArrayList<DeviceBuilder>();}
    for (Device item : items) {DeviceBuilder builder = new DeviceBuilder(item);_visitables.get("devices").add(builder);this.devices.add(builder);} return (A)this;
  }
  
  public A removeFromDevices(io.fabric8.kubernetes.api.model.resource.v1beta1.Device... items) {
    if (this.devices == null) return (A)this;
    for (Device item : items) {DeviceBuilder builder = new DeviceBuilder(item);_visitables.get("devices").remove(builder); this.devices.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDevices(Collection<Device> items) {
    if (this.devices == null) return (A)this;
    for (Device item : items) {DeviceBuilder builder = new DeviceBuilder(item);_visitables.get("devices").remove(builder); this.devices.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDevices(Predicate<DeviceBuilder> predicate) {
    if (devices == null) return (A) this;
    final Iterator<DeviceBuilder> each = devices.iterator();
    final List visitables = _visitables.get("devices");
    while (each.hasNext()) {
      DeviceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Device> buildDevices() {
    return this.devices != null ? build(devices) : null;
  }
  
  public Device buildDevice(int index) {
    return this.devices.get(index).build();
  }
  
  public Device buildFirstDevice() {
    return this.devices.get(0).build();
  }
  
  public Device buildLastDevice() {
    return this.devices.get(devices.size() - 1).build();
  }
  
  public Device buildMatchingDevice(Predicate<DeviceBuilder> predicate) {
      for (DeviceBuilder item : devices) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDevice(Predicate<DeviceBuilder> predicate) {
      for (DeviceBuilder item : devices) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDevices(List<Device> devices) {
    if (this.devices != null) {
      this._visitables.get("devices").clear();
    }
    if (devices != null) {
        this.devices = new ArrayList();
        for (Device item : devices) {
          this.addToDevices(item);
        }
    } else {
      this.devices = null;
    }
    return (A) this;
  }
  
  public A withDevices(io.fabric8.kubernetes.api.model.resource.v1beta1.Device... devices) {
    if (this.devices != null) {
        this.devices.clear();
        _visitables.remove("devices");
    }
    if (devices != null) {
      for (Device item : devices) {
        this.addToDevices(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDevices() {
    return this.devices != null && !this.devices.isEmpty();
  }
  
  public DevicesNested<A> addNewDevice() {
    return new DevicesNested(-1, null);
  }
  
  public DevicesNested<A> addNewDeviceLike(Device item) {
    return new DevicesNested(-1, item);
  }
  
  public DevicesNested<A> setNewDeviceLike(int index,Device item) {
    return new DevicesNested(index, item);
  }
  
  public DevicesNested<A> editDevice(int index) {
    if (devices.size() <= index) throw new RuntimeException("Can't edit devices. Index exceeds size.");
    return setNewDeviceLike(index, buildDevice(index));
  }
  
  public DevicesNested<A> editFirstDevice() {
    if (devices.size() == 0) throw new RuntimeException("Can't edit first devices. The list is empty.");
    return setNewDeviceLike(0, buildDevice(0));
  }
  
  public DevicesNested<A> editLastDevice() {
    int index = devices.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last devices. The list is empty.");
    return setNewDeviceLike(index, buildDevice(index));
  }
  
  public DevicesNested<A> editMatchingDevice(Predicate<DeviceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<devices.size();i++) { 
    if (predicate.test(devices.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching devices. No match found.");
    return setNewDeviceLike(index, buildDevice(index));
  }
  
  public String getDriver() {
    return this.driver;
  }
  
  public A withDriver(String driver) {
    this.driver = driver;
    return (A) this;
  }
  
  public boolean hasDriver() {
    return this.driver != null;
  }
  
  public String getNodeName() {
    return this.nodeName;
  }
  
  public A withNodeName(String nodeName) {
    this.nodeName = nodeName;
    return (A) this;
  }
  
  public boolean hasNodeName() {
    return this.nodeName != null;
  }
  
  public NodeSelector getNodeSelector() {
    return this.nodeSelector;
  }
  
  public A withNodeSelector(NodeSelector nodeSelector) {
    this.nodeSelector = nodeSelector;
    return (A) this;
  }
  
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  public Boolean getPerDeviceNodeSelection() {
    return this.perDeviceNodeSelection;
  }
  
  public A withPerDeviceNodeSelection(Boolean perDeviceNodeSelection) {
    this.perDeviceNodeSelection = perDeviceNodeSelection;
    return (A) this;
  }
  
  public boolean hasPerDeviceNodeSelection() {
    return this.perDeviceNodeSelection != null;
  }
  
  public ResourcePool buildPool() {
    return this.pool != null ? this.pool.build() : null;
  }
  
  public A withPool(ResourcePool pool) {
    this._visitables.remove("pool");
    if (pool != null) {
        this.pool = new ResourcePoolBuilder(pool);
        this._visitables.get("pool").add(this.pool);
    } else {
        this.pool = null;
        this._visitables.get("pool").remove(this.pool);
    }
    return (A) this;
  }
  
  public boolean hasPool() {
    return this.pool != null;
  }
  
  public A withNewPool(Long generation,String name,Long resourceSliceCount) {
    return (A)withPool(new ResourcePool(generation, name, resourceSliceCount));
  }
  
  public PoolNested<A> withNewPool() {
    return new PoolNested(null);
  }
  
  public PoolNested<A> withNewPoolLike(ResourcePool item) {
    return new PoolNested(item);
  }
  
  public PoolNested<A> editPool() {
    return withNewPoolLike(java.util.Optional.ofNullable(buildPool()).orElse(null));
  }
  
  public PoolNested<A> editOrNewPool() {
    return withNewPoolLike(java.util.Optional.ofNullable(buildPool()).orElse(new ResourcePoolBuilder().build()));
  }
  
  public PoolNested<A> editOrNewPoolLike(ResourcePool item) {
    return withNewPoolLike(java.util.Optional.ofNullable(buildPool()).orElse(item));
  }
  
  public A addToSharedCounters(int index,CounterSet item) {
    if (this.sharedCounters == null) {this.sharedCounters = new ArrayList<CounterSetBuilder>();}
    CounterSetBuilder builder = new CounterSetBuilder(item);
    if (index < 0 || index >= sharedCounters.size()) {
        _visitables.get("sharedCounters").add(builder);
        sharedCounters.add(builder);
    } else {
        _visitables.get("sharedCounters").add(builder);
        sharedCounters.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSharedCounters(int index,CounterSet item) {
    if (this.sharedCounters == null) {this.sharedCounters = new ArrayList<CounterSetBuilder>();}
    CounterSetBuilder builder = new CounterSetBuilder(item);
    if (index < 0 || index >= sharedCounters.size()) {
        _visitables.get("sharedCounters").add(builder);
        sharedCounters.add(builder);
    } else {
        _visitables.get("sharedCounters").add(builder);
        sharedCounters.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSharedCounters(io.fabric8.kubernetes.api.model.resource.v1beta1.CounterSet... items) {
    if (this.sharedCounters == null) {this.sharedCounters = new ArrayList<CounterSetBuilder>();}
    for (CounterSet item : items) {CounterSetBuilder builder = new CounterSetBuilder(item);_visitables.get("sharedCounters").add(builder);this.sharedCounters.add(builder);} return (A)this;
  }
  
  public A addAllToSharedCounters(Collection<CounterSet> items) {
    if (this.sharedCounters == null) {this.sharedCounters = new ArrayList<CounterSetBuilder>();}
    for (CounterSet item : items) {CounterSetBuilder builder = new CounterSetBuilder(item);_visitables.get("sharedCounters").add(builder);this.sharedCounters.add(builder);} return (A)this;
  }
  
  public A removeFromSharedCounters(io.fabric8.kubernetes.api.model.resource.v1beta1.CounterSet... items) {
    if (this.sharedCounters == null) return (A)this;
    for (CounterSet item : items) {CounterSetBuilder builder = new CounterSetBuilder(item);_visitables.get("sharedCounters").remove(builder); this.sharedCounters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSharedCounters(Collection<CounterSet> items) {
    if (this.sharedCounters == null) return (A)this;
    for (CounterSet item : items) {CounterSetBuilder builder = new CounterSetBuilder(item);_visitables.get("sharedCounters").remove(builder); this.sharedCounters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSharedCounters(Predicate<CounterSetBuilder> predicate) {
    if (sharedCounters == null) return (A) this;
    final Iterator<CounterSetBuilder> each = sharedCounters.iterator();
    final List visitables = _visitables.get("sharedCounters");
    while (each.hasNext()) {
      CounterSetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CounterSet> buildSharedCounters() {
    return this.sharedCounters != null ? build(sharedCounters) : null;
  }
  
  public CounterSet buildSharedCounter(int index) {
    return this.sharedCounters.get(index).build();
  }
  
  public CounterSet buildFirstSharedCounter() {
    return this.sharedCounters.get(0).build();
  }
  
  public CounterSet buildLastSharedCounter() {
    return this.sharedCounters.get(sharedCounters.size() - 1).build();
  }
  
  public CounterSet buildMatchingSharedCounter(Predicate<CounterSetBuilder> predicate) {
      for (CounterSetBuilder item : sharedCounters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSharedCounter(Predicate<CounterSetBuilder> predicate) {
      for (CounterSetBuilder item : sharedCounters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSharedCounters(List<CounterSet> sharedCounters) {
    if (this.sharedCounters != null) {
      this._visitables.get("sharedCounters").clear();
    }
    if (sharedCounters != null) {
        this.sharedCounters = new ArrayList();
        for (CounterSet item : sharedCounters) {
          this.addToSharedCounters(item);
        }
    } else {
      this.sharedCounters = null;
    }
    return (A) this;
  }
  
  public A withSharedCounters(io.fabric8.kubernetes.api.model.resource.v1beta1.CounterSet... sharedCounters) {
    if (this.sharedCounters != null) {
        this.sharedCounters.clear();
        _visitables.remove("sharedCounters");
    }
    if (sharedCounters != null) {
      for (CounterSet item : sharedCounters) {
        this.addToSharedCounters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSharedCounters() {
    return this.sharedCounters != null && !this.sharedCounters.isEmpty();
  }
  
  public SharedCountersNested<A> addNewSharedCounter() {
    return new SharedCountersNested(-1, null);
  }
  
  public SharedCountersNested<A> addNewSharedCounterLike(CounterSet item) {
    return new SharedCountersNested(-1, item);
  }
  
  public SharedCountersNested<A> setNewSharedCounterLike(int index,CounterSet item) {
    return new SharedCountersNested(index, item);
  }
  
  public SharedCountersNested<A> editSharedCounter(int index) {
    if (sharedCounters.size() <= index) throw new RuntimeException("Can't edit sharedCounters. Index exceeds size.");
    return setNewSharedCounterLike(index, buildSharedCounter(index));
  }
  
  public SharedCountersNested<A> editFirstSharedCounter() {
    if (sharedCounters.size() == 0) throw new RuntimeException("Can't edit first sharedCounters. The list is empty.");
    return setNewSharedCounterLike(0, buildSharedCounter(0));
  }
  
  public SharedCountersNested<A> editLastSharedCounter() {
    int index = sharedCounters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sharedCounters. The list is empty.");
    return setNewSharedCounterLike(index, buildSharedCounter(index));
  }
  
  public SharedCountersNested<A> editMatchingSharedCounter(Predicate<CounterSetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sharedCounters.size();i++) { 
    if (predicate.test(sharedCounters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sharedCounters. No match found.");
    return setNewSharedCounterLike(index, buildSharedCounter(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceSliceSpecFluent that = (ResourceSliceSpecFluent) o;
    if (!java.util.Objects.equals(allNodes, that.allNodes)) return false;
    if (!java.util.Objects.equals(devices, that.devices)) return false;
    if (!java.util.Objects.equals(driver, that.driver)) return false;
    if (!java.util.Objects.equals(nodeName, that.nodeName)) return false;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;
    if (!java.util.Objects.equals(perDeviceNodeSelection, that.perDeviceNodeSelection)) return false;
    if (!java.util.Objects.equals(pool, that.pool)) return false;
    if (!java.util.Objects.equals(sharedCounters, that.sharedCounters)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allNodes,  devices,  driver,  nodeName,  nodeSelector,  perDeviceNodeSelection,  pool,  sharedCounters,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allNodes != null) { sb.append("allNodes:"); sb.append(allNodes + ","); }
    if (devices != null && !devices.isEmpty()) { sb.append("devices:"); sb.append(devices + ","); }
    if (driver != null) { sb.append("driver:"); sb.append(driver + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (nodeSelector != null) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (perDeviceNodeSelection != null) { sb.append("perDeviceNodeSelection:"); sb.append(perDeviceNodeSelection + ","); }
    if (pool != null) { sb.append("pool:"); sb.append(pool + ","); }
    if (sharedCounters != null && !sharedCounters.isEmpty()) { sb.append("sharedCounters:"); sb.append(sharedCounters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withAllNodes() {
    return withAllNodes(true);
  }
  
  public A withPerDeviceNodeSelection() {
    return withPerDeviceNodeSelection(true);
  }
  public class DevicesNested<N> extends DeviceFluent<DevicesNested<N>> implements Nested<N>{
    DevicesNested(int index,Device item) {
      this.index = index;
      this.builder = new DeviceBuilder(this, item);
    }
    DeviceBuilder builder;
    int index;
    
    public N and() {
      return (N) ResourceSliceSpecFluent.this.setToDevices(index,builder.build());
    }
    
    public N endDevice() {
      return and();
    }
    
  
  }
  public class PoolNested<N> extends ResourcePoolFluent<PoolNested<N>> implements Nested<N>{
    PoolNested(ResourcePool item) {
      this.builder = new ResourcePoolBuilder(this, item);
    }
    ResourcePoolBuilder builder;
    
    public N and() {
      return (N) ResourceSliceSpecFluent.this.withPool(builder.build());
    }
    
    public N endPool() {
      return and();
    }
    
  
  }
  public class SharedCountersNested<N> extends CounterSetFluent<SharedCountersNested<N>> implements Nested<N>{
    SharedCountersNested(int index,CounterSet item) {
      this.index = index;
      this.builder = new CounterSetBuilder(this, item);
    }
    CounterSetBuilder builder;
    int index;
    
    public N and() {
      return (N) ResourceSliceSpecFluent.this.setToSharedCounters(index,builder.build());
    }
    
    public N endSharedCounter() {
      return and();
    }
    
  
  }

}