/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimSchedulingStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourceClaimSchedulingStatusFluent<A extends ResourceClaimSchedulingStatusFluent<A>>
extends BaseFluent<A> {
    private String name;
    private List<String> unsuitableNodes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ResourceClaimSchedulingStatusFluent() {
    }

    public ResourceClaimSchedulingStatusFluent(ResourceClaimSchedulingStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceClaimSchedulingStatus instance) {
        ResourceClaimSchedulingStatus resourceClaimSchedulingStatus = instance = instance != null ? instance : new ResourceClaimSchedulingStatus();
        if (instance != null) {
            this.withName(instance.getName());
            this.withUnsuitableNodes(instance.getUnsuitableNodes());
            this.withName(instance.getName());
            this.withUnsuitableNodes(instance.getUnsuitableNodes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToUnsuitableNodes(int index, String item) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.add(index, item);
        return (A)((Object)this);
    }

    public A setToUnsuitableNodes(int index, String item) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.set(index, item);
        return (A)((Object)this);
    }

    public A addToUnsuitableNodes(String ... items) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.unsuitableNodes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToUnsuitableNodes(Collection<String> items) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        for (String item : items) {
            this.unsuitableNodes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromUnsuitableNodes(String ... items) {
        if (this.unsuitableNodes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.unsuitableNodes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromUnsuitableNodes(Collection<String> items) {
        if (this.unsuitableNodes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.unsuitableNodes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getUnsuitableNodes() {
        return this.unsuitableNodes;
    }

    public String getUnsuitableNode(int index) {
        return this.unsuitableNodes.get(index);
    }

    public String getFirstUnsuitableNode() {
        return this.unsuitableNodes.get(0);
    }

    public String getLastUnsuitableNode() {
        return this.unsuitableNodes.get(this.unsuitableNodes.size() - 1);
    }

    public String getMatchingUnsuitableNode(Predicate<String> predicate) {
        for (String item : this.unsuitableNodes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUnsuitableNode(Predicate<String> predicate) {
        for (String item : this.unsuitableNodes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUnsuitableNodes(List<String> unsuitableNodes) {
        if (unsuitableNodes != null) {
            this.unsuitableNodes = new ArrayList<String>();
            for (String item : unsuitableNodes) {
                this.addToUnsuitableNodes(item);
            }
        } else {
            this.unsuitableNodes = null;
        }
        return (A)((Object)this);
    }

    public A withUnsuitableNodes(String ... unsuitableNodes) {
        if (this.unsuitableNodes != null) {
            this.unsuitableNodes.clear();
            this._visitables.remove((Object)"unsuitableNodes");
        }
        if (unsuitableNodes != null) {
            for (String item : unsuitableNodes) {
                this.addToUnsuitableNodes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasUnsuitableNodes() {
        return this.unsuitableNodes != null && !this.unsuitableNodes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClaimSchedulingStatusFluent that = (ResourceClaimSchedulingStatusFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.unsuitableNodes, that.unsuitableNodes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.unsuitableNodes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.unsuitableNodes != null && !this.unsuitableNodes.isEmpty()) {
            sb.append("unsuitableNodes:");
            sb.append(this.unsuitableNodes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

