package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceHandleBuilder extends ResourceHandleFluent<ResourceHandleBuilder> implements VisitableBuilder<ResourceHandle,ResourceHandleBuilder>{
  public ResourceHandleBuilder() {
    this(false);
  }
  public ResourceHandleBuilder(Boolean validationEnabled) {
    this(new ResourceHandle(), validationEnabled);
  }
  public ResourceHandleBuilder(ResourceHandleFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceHandleBuilder(ResourceHandleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceHandle(), validationEnabled);
  }
  public ResourceHandleBuilder(ResourceHandleFluent<?> fluent,ResourceHandle instance) {
    this(fluent, instance, false);
  }
  public ResourceHandleBuilder(ResourceHandleFluent<?> fluent,ResourceHandle instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceHandle());

    if (instance != null) {
      fluent.withData(instance.getData());
      fluent.withDriverName(instance.getDriverName());
      fluent.withData(instance.getData());
      fluent.withDriverName(instance.getDriverName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceHandleBuilder(ResourceHandle instance) {
    this(instance,false);
  }
  public ResourceHandleBuilder(ResourceHandle instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceHandle());

    if (instance != null) {
      this.withData(instance.getData());
      this.withDriverName(instance.getDriverName());
      this.withData(instance.getData());
      this.withDriverName(instance.getDriverName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceHandleFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceHandle build() {
    ResourceHandle buildable = new ResourceHandle(fluent.getData(),fluent.getDriverName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}