package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceClaimTemplateBuilder extends ResourceClaimTemplateFluentImpl<ResourceClaimTemplateBuilder> implements VisitableBuilder<ResourceClaimTemplate,ResourceClaimTemplateBuilder>{
  public ResourceClaimTemplateBuilder() {
    this(false);
  }
  public ResourceClaimTemplateBuilder(Boolean validationEnabled) {
    this(new ResourceClaimTemplate(), validationEnabled);
  }
  public ResourceClaimTemplateBuilder(ResourceClaimTemplateFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceClaimTemplateBuilder(ResourceClaimTemplateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceClaimTemplate(), validationEnabled);
  }
  public ResourceClaimTemplateBuilder(ResourceClaimTemplateFluent<?> fluent,ResourceClaimTemplate instance) {
    this(fluent, instance, false);
  }
  public ResourceClaimTemplateBuilder(ResourceClaimTemplateFluent<?> fluent,ResourceClaimTemplate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceClaimTemplateBuilder(ResourceClaimTemplate instance) {
    this(instance,false);
  }
  public ResourceClaimTemplateBuilder(ResourceClaimTemplate instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ResourceClaimTemplateFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceClaimTemplate build() {
    ResourceClaimTemplate buildable = new ResourceClaimTemplate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}