package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingStatusBuilder extends PodSchedulingStatusFluentImpl<PodSchedulingStatusBuilder> implements VisitableBuilder<PodSchedulingStatus,PodSchedulingStatusBuilder>{
  public PodSchedulingStatusBuilder() {
    this(false);
  }
  public PodSchedulingStatusBuilder(Boolean validationEnabled) {
    this(new PodSchedulingStatus(), validationEnabled);
  }
  public PodSchedulingStatusBuilder(PodSchedulingStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingStatusBuilder(PodSchedulingStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSchedulingStatus(), validationEnabled);
  }
  public PodSchedulingStatusBuilder(PodSchedulingStatusFluent<?> fluent,PodSchedulingStatus instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingStatusBuilder(PodSchedulingStatusFluent<?> fluent,PodSchedulingStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withResourceClaims(instance.getResourceClaims()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingStatusBuilder(PodSchedulingStatus instance) {
    this(instance,false);
  }
  public PodSchedulingStatusBuilder(PodSchedulingStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withResourceClaims(instance.getResourceClaims()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodSchedulingStatus build() {
    PodSchedulingStatus buildable = new PodSchedulingStatus(fluent.getResourceClaims());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}