package io.fabric8.kubernetes.api.model.resource.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.NodeSelector;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AllocationResultFluentImpl<A extends AllocationResultFluent<A>> extends BaseFluent<A> implements AllocationResultFluent<A>{
  public AllocationResultFluentImpl() {
  }
  public AllocationResultFluentImpl(AllocationResult instance) {
    this.withAvailableOnNodes(instance.getAvailableOnNodes()); 
    this.withResourceHandle(instance.getResourceHandle()); 
    this.withShareable(instance.getShareable()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private NodeSelector availableOnNodes;
  private String resourceHandle;
  private Boolean shareable;
  private Map<String,Object> additionalProperties;
  public NodeSelector getAvailableOnNodes() {
    return this.availableOnNodes;
  }
  public A withAvailableOnNodes(NodeSelector availableOnNodes) {
    this.availableOnNodes=availableOnNodes; return (A) this;
  }
  public Boolean hasAvailableOnNodes() {
    return this.availableOnNodes != null;
  }
  public String getResourceHandle() {
    return this.resourceHandle;
  }
  public A withResourceHandle(String resourceHandle) {
    this.resourceHandle=resourceHandle; return (A) this;
  }
  public Boolean hasResourceHandle() {
    return this.resourceHandle != null;
  }
  public Boolean getShareable() {
    return this.shareable;
  }
  public A withShareable(Boolean shareable) {
    this.shareable=shareable; return (A) this;
  }
  public Boolean hasShareable() {
    return this.shareable != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AllocationResultFluentImpl that = (AllocationResultFluentImpl) o;
    if (availableOnNodes != null ? !availableOnNodes.equals(that.availableOnNodes) :that.availableOnNodes != null) return false;
    if (resourceHandle != null ? !resourceHandle.equals(that.resourceHandle) :that.resourceHandle != null) return false;
    if (shareable != null ? !shareable.equals(that.shareable) :that.shareable != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(availableOnNodes,  resourceHandle,  shareable,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availableOnNodes != null) { sb.append("availableOnNodes:"); sb.append(availableOnNodes + ","); }
    if (resourceHandle != null) { sb.append("resourceHandle:"); sb.append(resourceHandle + ","); }
    if (shareable != null) { sb.append("shareable:"); sb.append(shareable + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withShareable() {
    return withShareable(true);
  }
  
}