package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleListBuilder extends ClusterRoleListFluent<ClusterRoleListBuilder> implements VisitableBuilder<ClusterRoleList,ClusterRoleListBuilder>{
  public ClusterRoleListBuilder() {
    this(false);
  }
  public ClusterRoleListBuilder(Boolean validationEnabled) {
    this(new ClusterRoleList(), validationEnabled);
  }
  public ClusterRoleListBuilder(ClusterRoleListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleListBuilder(ClusterRoleListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRoleList(), validationEnabled);
  }
  public ClusterRoleListBuilder(ClusterRoleListFluent<?> fluent,ClusterRoleList instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleListBuilder(ClusterRoleListFluent<?> fluent,ClusterRoleList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterRoleList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleListBuilder(ClusterRoleList instance) {
    this(instance,false);
  }
  public ClusterRoleListBuilder(ClusterRoleList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterRoleList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterRoleListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRoleList build() {
    ClusterRoleList buildable = new ClusterRoleList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}