package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AggregationRuleBuilder extends AggregationRuleFluentImpl<AggregationRuleBuilder> implements VisitableBuilder<AggregationRule,AggregationRuleBuilder>{
  public AggregationRuleBuilder() {
    this(false);
  }
  public AggregationRuleBuilder(Boolean validationEnabled) {
    this(new AggregationRule(), validationEnabled);
  }
  public AggregationRuleBuilder(AggregationRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public AggregationRuleBuilder(AggregationRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AggregationRule(), validationEnabled);
  }
  public AggregationRuleBuilder(AggregationRuleFluent<?> fluent,AggregationRule instance) {
    this(fluent, instance, false);
  }
  public AggregationRuleBuilder(AggregationRuleFluent<?> fluent,AggregationRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AggregationRuleBuilder(AggregationRule instance) {
    this(instance,false);
  }
  public AggregationRuleBuilder(AggregationRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AggregationRuleFluent<?> fluent;
  Boolean validationEnabled;
  public AggregationRule build() {
    AggregationRule buildable = new AggregationRule(fluent.getClusterRoleSelectors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}