package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectBuilder extends SubjectFluentImpl<SubjectBuilder> implements VisitableBuilder<Subject,SubjectBuilder>{
  public SubjectBuilder() {
    this(false);
  }
  public SubjectBuilder(Boolean validationEnabled) {
    this(new Subject(), validationEnabled);
  }
  public SubjectBuilder(SubjectFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Subject(), validationEnabled);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Subject instance) {
    this(fluent, instance, false);
  }
  public SubjectBuilder(SubjectFluent<?> fluent,Subject instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroup(instance.getApiGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SubjectBuilder(Subject instance) {
    this(instance,false);
  }
  public SubjectBuilder(Subject instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroup(instance.getApiGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SubjectFluent<?> fluent;
  Boolean validationEnabled;
  public Subject build() {
    Subject buildable = new Subject(fluent.getApiGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}