package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubjectBuilder extends io.fabric8.kubernetes.api.model.rbac.SubjectFluentImpl<io.fabric8.kubernetes.api.model.rbac.SubjectBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.rbac.Subject,io.fabric8.kubernetes.api.model.rbac.SubjectBuilder> {

    io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public SubjectBuilder() {
        this(true);
    }

    public SubjectBuilder(java.lang.Boolean validationEnabled) {
        this(new Subject(), validationEnabled);
    }

    public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent) {
        this(fluent, true);
    }

    public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Subject(), validationEnabled);
    }

    public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.Subject instance) {
        this(fluent, instance, true);
    }

    public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.SubjectFluent<?> fluent,io.fabric8.kubernetes.api.model.rbac.Subject instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiGroup(instance.getApiGroup()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.Subject instance) {
        this(instance,true);
    }

    public SubjectBuilder(io.fabric8.kubernetes.api.model.rbac.Subject instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiGroup(instance.getApiGroup()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.rbac.Subject build() {
        Subject buildable = new Subject(fluent.getApiGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SubjectBuilder that = (SubjectBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
