/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriver;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedCSIDriverFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolume;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedFlexVolumeFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPath;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.AllowedHostPathFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.FSGroupStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRange;
import io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.HostPortRangeFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodSecurityPolicySpec;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsGroupStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RunAsUserStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.RuntimeClassStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.SELinuxStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptions;
import io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.SupplementalGroupsStrategyOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PodSecurityPolicySpecFluent<A extends PodSecurityPolicySpecFluent<A>>
extends BaseFluent<A> {
    private Boolean allowPrivilegeEscalation;
    private ArrayList<AllowedCSIDriverBuilder> allowedCSIDrivers = new ArrayList();
    private List<String> allowedCapabilities = new ArrayList<String>();
    private ArrayList<AllowedFlexVolumeBuilder> allowedFlexVolumes = new ArrayList();
    private ArrayList<AllowedHostPathBuilder> allowedHostPaths = new ArrayList();
    private List<String> allowedProcMountTypes = new ArrayList<String>();
    private List<String> allowedUnsafeSysctls = new ArrayList<String>();
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    private Boolean defaultAllowPrivilegeEscalation;
    private List<String> forbiddenSysctls = new ArrayList<String>();
    private FSGroupStrategyOptionsBuilder fsGroup;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private ArrayList<HostPortRangeBuilder> hostPorts = new ArrayList();
    private Boolean privileged;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    private RunAsGroupStrategyOptionsBuilder runAsGroup;
    private RunAsUserStrategyOptionsBuilder runAsUser;
    private RuntimeClassStrategyOptionsBuilder runtimeClass;
    private SELinuxStrategyOptionsBuilder seLinux;
    private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> volumes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public PodSecurityPolicySpecFluent() {
    }

    public PodSecurityPolicySpecFluent(PodSecurityPolicySpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PodSecurityPolicySpec instance) {
        PodSecurityPolicySpec podSecurityPolicySpec = instance = instance != null ? instance : new PodSecurityPolicySpec();
        if (instance != null) {
            this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
            this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());
            this.withAllowedCapabilities(instance.getAllowedCapabilities());
            this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
            this.withAllowedHostPaths(instance.getAllowedHostPaths());
            this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());
            this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
            this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
            this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
            this.withForbiddenSysctls(instance.getForbiddenSysctls());
            this.withFsGroup(instance.getFsGroup());
            this.withHostIPC(instance.getHostIPC());
            this.withHostNetwork(instance.getHostNetwork());
            this.withHostPID(instance.getHostPID());
            this.withHostPorts(instance.getHostPorts());
            this.withPrivileged(instance.getPrivileged());
            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
            this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
            this.withRunAsGroup(instance.getRunAsGroup());
            this.withRunAsUser(instance.getRunAsUser());
            this.withRuntimeClass(instance.getRuntimeClass());
            this.withSeLinux(instance.getSeLinux());
            this.withSupplementalGroups(instance.getSupplementalGroups());
            this.withVolumes(instance.getVolumes());
            this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
            this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());
            this.withAllowedCapabilities(instance.getAllowedCapabilities());
            this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
            this.withAllowedHostPaths(instance.getAllowedHostPaths());
            this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());
            this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());
            this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
            this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());
            this.withForbiddenSysctls(instance.getForbiddenSysctls());
            this.withFsGroup(instance.getFsGroup());
            this.withHostIPC(instance.getHostIPC());
            this.withHostNetwork(instance.getHostNetwork());
            this.withHostPID(instance.getHostPID());
            this.withHostPorts(instance.getHostPorts());
            this.withPrivileged(instance.getPrivileged());
            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
            this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
            this.withRunAsGroup(instance.getRunAsGroup());
            this.withRunAsUser(instance.getRunAsUser());
            this.withRuntimeClass(instance.getRuntimeClass());
            this.withSeLinux(instance.getSeLinux());
            this.withSupplementalGroups(instance.getSupplementalGroups());
            this.withVolumes(instance.getVolumes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)((Object)this);
    }

    public boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    public A addToAllowedCSIDrivers(int index, AllowedCSIDriver item) {
        if (this.allowedCSIDrivers == null) {
            this.allowedCSIDrivers = new ArrayList();
        }
        AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
        if (index < 0 || index >= this.allowedCSIDrivers.size()) {
            this._visitables.get((Object)"allowedCSIDrivers").add(builder);
            this.allowedCSIDrivers.add(builder);
        } else {
            this._visitables.get((Object)"allowedCSIDrivers").add(index, builder);
            this.allowedCSIDrivers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAllowedCSIDrivers(int index, AllowedCSIDriver item) {
        if (this.allowedCSIDrivers == null) {
            this.allowedCSIDrivers = new ArrayList();
        }
        AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
        if (index < 0 || index >= this.allowedCSIDrivers.size()) {
            this._visitables.get((Object)"allowedCSIDrivers").add(builder);
            this.allowedCSIDrivers.add(builder);
        } else {
            this._visitables.get((Object)"allowedCSIDrivers").set(index, builder);
            this.allowedCSIDrivers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAllowedCSIDrivers(AllowedCSIDriver ... items) {
        if (this.allowedCSIDrivers == null) {
            this.allowedCSIDrivers = new ArrayList();
        }
        for (AllowedCSIDriver item : items) {
            AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
            this._visitables.get((Object)"allowedCSIDrivers").add(builder);
            this.allowedCSIDrivers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedCSIDrivers(Collection<AllowedCSIDriver> items) {
        if (this.allowedCSIDrivers == null) {
            this.allowedCSIDrivers = new ArrayList();
        }
        for (AllowedCSIDriver item : items) {
            AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
            this._visitables.get((Object)"allowedCSIDrivers").add(builder);
            this.allowedCSIDrivers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedCSIDrivers(AllowedCSIDriver ... items) {
        if (this.allowedCSIDrivers == null) {
            return (A)((Object)this);
        }
        for (AllowedCSIDriver item : items) {
            AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
            this._visitables.get((Object)"allowedCSIDrivers").remove((Object)builder);
            this.allowedCSIDrivers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedCSIDrivers(Collection<AllowedCSIDriver> items) {
        if (this.allowedCSIDrivers == null) {
            return (A)((Object)this);
        }
        for (AllowedCSIDriver item : items) {
            AllowedCSIDriverBuilder builder = new AllowedCSIDriverBuilder(item);
            this._visitables.get((Object)"allowedCSIDrivers").remove((Object)builder);
            this.allowedCSIDrivers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAllowedCSIDrivers(Predicate<AllowedCSIDriverBuilder> predicate) {
        if (this.allowedCSIDrivers == null) {
            return (A)((Object)this);
        }
        Iterator<AllowedCSIDriverBuilder> each = this.allowedCSIDrivers.iterator();
        List visitables = this._visitables.get((Object)"allowedCSIDrivers");
        while (each.hasNext()) {
            AllowedCSIDriverBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AllowedCSIDriver> buildAllowedCSIDrivers() {
        return this.allowedCSIDrivers != null ? PodSecurityPolicySpecFluent.build(this.allowedCSIDrivers) : null;
    }

    public AllowedCSIDriver buildAllowedCSIDriver(int index) {
        return this.allowedCSIDrivers.get(index).build();
    }

    public AllowedCSIDriver buildFirstAllowedCSIDriver() {
        return this.allowedCSIDrivers.get(0).build();
    }

    public AllowedCSIDriver buildLastAllowedCSIDriver() {
        return this.allowedCSIDrivers.get(this.allowedCSIDrivers.size() - 1).build();
    }

    public AllowedCSIDriver buildMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
        for (AllowedCSIDriverBuilder item : this.allowedCSIDrivers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
        for (AllowedCSIDriverBuilder item : this.allowedCSIDrivers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedCSIDrivers(List<AllowedCSIDriver> allowedCSIDrivers) {
        if (this.allowedCSIDrivers != null) {
            this._visitables.get((Object)"allowedCSIDrivers").clear();
        }
        if (allowedCSIDrivers != null) {
            this.allowedCSIDrivers = new ArrayList();
            for (AllowedCSIDriver item : allowedCSIDrivers) {
                this.addToAllowedCSIDrivers(item);
            }
        } else {
            this.allowedCSIDrivers = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedCSIDrivers(AllowedCSIDriver ... allowedCSIDrivers) {
        if (this.allowedCSIDrivers != null) {
            this.allowedCSIDrivers.clear();
            this._visitables.remove((Object)"allowedCSIDrivers");
        }
        if (allowedCSIDrivers != null) {
            for (AllowedCSIDriver item : allowedCSIDrivers) {
                this.addToAllowedCSIDrivers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedCSIDrivers() {
        return this.allowedCSIDrivers != null && !this.allowedCSIDrivers.isEmpty();
    }

    public A addNewAllowedCSIDriver(String name) {
        return this.addToAllowedCSIDrivers(new AllowedCSIDriver(name));
    }

    public AllowedCSIDriversNested<A> addNewAllowedCSIDriver() {
        return new AllowedCSIDriversNested(-1, null);
    }

    public AllowedCSIDriversNested<A> addNewAllowedCSIDriverLike(AllowedCSIDriver item) {
        return new AllowedCSIDriversNested(-1, item);
    }

    public AllowedCSIDriversNested<A> setNewAllowedCSIDriverLike(int index, AllowedCSIDriver item) {
        return new AllowedCSIDriversNested(index, item);
    }

    public AllowedCSIDriversNested<A> editAllowedCSIDriver(int index) {
        if (this.allowedCSIDrivers.size() <= index) {
            throw new RuntimeException("Can't edit allowedCSIDrivers. Index exceeds size.");
        }
        return this.setNewAllowedCSIDriverLike(index, this.buildAllowedCSIDriver(index));
    }

    public AllowedCSIDriversNested<A> editFirstAllowedCSIDriver() {
        if (this.allowedCSIDrivers.size() == 0) {
            throw new RuntimeException("Can't edit first allowedCSIDrivers. The list is empty.");
        }
        return this.setNewAllowedCSIDriverLike(0, this.buildAllowedCSIDriver(0));
    }

    public AllowedCSIDriversNested<A> editLastAllowedCSIDriver() {
        int index = this.allowedCSIDrivers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedCSIDrivers. The list is empty.");
        }
        return this.setNewAllowedCSIDriverLike(index, this.buildAllowedCSIDriver(index));
    }

    public AllowedCSIDriversNested<A> editMatchingAllowedCSIDriver(Predicate<AllowedCSIDriverBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedCSIDrivers.size(); ++i) {
            if (!predicate.test(this.allowedCSIDrivers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedCSIDrivers. No match found.");
        }
        return this.setNewAllowedCSIDriverLike(index, this.buildAllowedCSIDriver(index));
    }

    public A addToAllowedCapabilities(int index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.add(index, item);
        return (A)((Object)this);
    }

    public A setToAllowedCapabilities(int index, String item) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        this.allowedCapabilities.set(index, item);
        return (A)((Object)this);
    }

    public A addToAllowedCapabilities(String ... items) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedCapabilities(Collection<String> items) {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedCapabilities(String ... items) {
        if (this.allowedCapabilities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedCapabilities(Collection<String> items) {
        if (this.allowedCapabilities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    public String getAllowedCapability(int index) {
        return this.allowedCapabilities.get(index);
    }

    public String getFirstAllowedCapability() {
        return this.allowedCapabilities.get(0);
    }

    public String getLastAllowedCapability() {
        return this.allowedCapabilities.get(this.allowedCapabilities.size() - 1);
    }

    public String getMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedCapabilities(List<String> allowedCapabilities) {
        if (allowedCapabilities != null) {
            this.allowedCapabilities = new ArrayList<String>();
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        } else {
            this.allowedCapabilities = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedCapabilities(String ... allowedCapabilities) {
        if (this.allowedCapabilities != null) {
            this.allowedCapabilities.clear();
            this._visitables.remove((Object)"allowedCapabilities");
        }
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedCapabilities() {
        return this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty();
    }

    public A addToAllowedFlexVolumes(int index, AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList();
        }
        AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
        if (index < 0 || index >= this.allowedFlexVolumes.size()) {
            this._visitables.get((Object)"allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        } else {
            this._visitables.get((Object)"allowedFlexVolumes").add(index, builder);
            this.allowedFlexVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAllowedFlexVolumes(int index, AllowedFlexVolume item) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList();
        }
        AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
        if (index < 0 || index >= this.allowedFlexVolumes.size()) {
            this._visitables.get((Object)"allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        } else {
            this._visitables.get((Object)"allowedFlexVolumes").set(index, builder);
            this.allowedFlexVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAllowedFlexVolumes(AllowedFlexVolume ... items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList();
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get((Object)"allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
        if (this.allowedFlexVolumes == null) {
            this.allowedFlexVolumes = new ArrayList();
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get((Object)"allowedFlexVolumes").add(builder);
            this.allowedFlexVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedFlexVolumes(AllowedFlexVolume ... items) {
        if (this.allowedFlexVolumes == null) {
            return (A)((Object)this);
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get((Object)"allowedFlexVolumes").remove((Object)builder);
            this.allowedFlexVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedFlexVolumes(Collection<AllowedFlexVolume> items) {
        if (this.allowedFlexVolumes == null) {
            return (A)((Object)this);
        }
        for (AllowedFlexVolume item : items) {
            AllowedFlexVolumeBuilder builder = new AllowedFlexVolumeBuilder(item);
            this._visitables.get((Object)"allowedFlexVolumes").remove((Object)builder);
            this.allowedFlexVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAllowedFlexVolumes(Predicate<AllowedFlexVolumeBuilder> predicate) {
        if (this.allowedFlexVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<AllowedFlexVolumeBuilder> each = this.allowedFlexVolumes.iterator();
        List visitables = this._visitables.get((Object)"allowedFlexVolumes");
        while (each.hasNext()) {
            AllowedFlexVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AllowedFlexVolume> buildAllowedFlexVolumes() {
        return this.allowedFlexVolumes != null ? PodSecurityPolicySpecFluent.build(this.allowedFlexVolumes) : null;
    }

    public AllowedFlexVolume buildAllowedFlexVolume(int index) {
        return this.allowedFlexVolumes.get(index).build();
    }

    public AllowedFlexVolume buildFirstAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(0).build();
    }

    public AllowedFlexVolume buildLastAllowedFlexVolume() {
        return this.allowedFlexVolumes.get(this.allowedFlexVolumes.size() - 1).build();
    }

    public AllowedFlexVolume buildMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        for (AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        for (AllowedFlexVolumeBuilder item : this.allowedFlexVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedFlexVolumes(List<AllowedFlexVolume> allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this._visitables.get((Object)"allowedFlexVolumes").clear();
        }
        if (allowedFlexVolumes != null) {
            this.allowedFlexVolumes = new ArrayList();
            for (AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        } else {
            this.allowedFlexVolumes = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedFlexVolumes(AllowedFlexVolume ... allowedFlexVolumes) {
        if (this.allowedFlexVolumes != null) {
            this.allowedFlexVolumes.clear();
            this._visitables.remove((Object)"allowedFlexVolumes");
        }
        if (allowedFlexVolumes != null) {
            for (AllowedFlexVolume item : allowedFlexVolumes) {
                this.addToAllowedFlexVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedFlexVolumes() {
        return this.allowedFlexVolumes != null && !this.allowedFlexVolumes.isEmpty();
    }

    public A addNewAllowedFlexVolume(String driver) {
        return this.addToAllowedFlexVolumes(new AllowedFlexVolume(driver));
    }

    public AllowedFlexVolumesNested<A> addNewAllowedFlexVolume() {
        return new AllowedFlexVolumesNested(-1, null);
    }

    public AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(AllowedFlexVolume item) {
        return new AllowedFlexVolumesNested(-1, item);
    }

    public AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index, AllowedFlexVolume item) {
        return new AllowedFlexVolumesNested(index, item);
    }

    public AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index) {
        if (this.allowedFlexVolumes.size() <= index) {
            throw new RuntimeException("Can't edit allowedFlexVolumes. Index exceeds size.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    public AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume() {
        if (this.allowedFlexVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(0, this.buildAllowedFlexVolume(0));
    }

    public AllowedFlexVolumesNested<A> editLastAllowedFlexVolume() {
        int index = this.allowedFlexVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedFlexVolumes. The list is empty.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    public AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(Predicate<AllowedFlexVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedFlexVolumes.size(); ++i) {
            if (!predicate.test(this.allowedFlexVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedFlexVolumes. No match found.");
        }
        return this.setNewAllowedFlexVolumeLike(index, this.buildAllowedFlexVolume(index));
    }

    public A addToAllowedHostPaths(int index, AllowedHostPath item) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList();
        }
        AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
        if (index < 0 || index >= this.allowedHostPaths.size()) {
            this._visitables.get((Object)"allowedHostPaths").add(builder);
            this.allowedHostPaths.add(builder);
        } else {
            this._visitables.get((Object)"allowedHostPaths").add(index, builder);
            this.allowedHostPaths.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAllowedHostPaths(int index, AllowedHostPath item) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList();
        }
        AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
        if (index < 0 || index >= this.allowedHostPaths.size()) {
            this._visitables.get((Object)"allowedHostPaths").add(builder);
            this.allowedHostPaths.add(builder);
        } else {
            this._visitables.get((Object)"allowedHostPaths").set(index, builder);
            this.allowedHostPaths.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAllowedHostPaths(AllowedHostPath ... items) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList();
        }
        for (AllowedHostPath item : items) {
            AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
            this._visitables.get((Object)"allowedHostPaths").add(builder);
            this.allowedHostPaths.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedHostPaths(Collection<AllowedHostPath> items) {
        if (this.allowedHostPaths == null) {
            this.allowedHostPaths = new ArrayList();
        }
        for (AllowedHostPath item : items) {
            AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
            this._visitables.get((Object)"allowedHostPaths").add(builder);
            this.allowedHostPaths.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedHostPaths(AllowedHostPath ... items) {
        if (this.allowedHostPaths == null) {
            return (A)((Object)this);
        }
        for (AllowedHostPath item : items) {
            AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
            this._visitables.get((Object)"allowedHostPaths").remove((Object)builder);
            this.allowedHostPaths.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedHostPaths(Collection<AllowedHostPath> items) {
        if (this.allowedHostPaths == null) {
            return (A)((Object)this);
        }
        for (AllowedHostPath item : items) {
            AllowedHostPathBuilder builder = new AllowedHostPathBuilder(item);
            this._visitables.get((Object)"allowedHostPaths").remove((Object)builder);
            this.allowedHostPaths.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAllowedHostPaths(Predicate<AllowedHostPathBuilder> predicate) {
        if (this.allowedHostPaths == null) {
            return (A)((Object)this);
        }
        Iterator<AllowedHostPathBuilder> each = this.allowedHostPaths.iterator();
        List visitables = this._visitables.get((Object)"allowedHostPaths");
        while (each.hasNext()) {
            AllowedHostPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AllowedHostPath> buildAllowedHostPaths() {
        return this.allowedHostPaths != null ? PodSecurityPolicySpecFluent.build(this.allowedHostPaths) : null;
    }

    public AllowedHostPath buildAllowedHostPath(int index) {
        return this.allowedHostPaths.get(index).build();
    }

    public AllowedHostPath buildFirstAllowedHostPath() {
        return this.allowedHostPaths.get(0).build();
    }

    public AllowedHostPath buildLastAllowedHostPath() {
        return this.allowedHostPaths.get(this.allowedHostPaths.size() - 1).build();
    }

    public AllowedHostPath buildMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
        for (AllowedHostPathBuilder item : this.allowedHostPaths) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
        for (AllowedHostPathBuilder item : this.allowedHostPaths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedHostPaths(List<AllowedHostPath> allowedHostPaths) {
        if (this.allowedHostPaths != null) {
            this._visitables.get((Object)"allowedHostPaths").clear();
        }
        if (allowedHostPaths != null) {
            this.allowedHostPaths = new ArrayList();
            for (AllowedHostPath item : allowedHostPaths) {
                this.addToAllowedHostPaths(item);
            }
        } else {
            this.allowedHostPaths = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedHostPaths(AllowedHostPath ... allowedHostPaths) {
        if (this.allowedHostPaths != null) {
            this.allowedHostPaths.clear();
            this._visitables.remove((Object)"allowedHostPaths");
        }
        if (allowedHostPaths != null) {
            for (AllowedHostPath item : allowedHostPaths) {
                this.addToAllowedHostPaths(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedHostPaths() {
        return this.allowedHostPaths != null && !this.allowedHostPaths.isEmpty();
    }

    public A addNewAllowedHostPath(String pathPrefix, Boolean readOnly) {
        return this.addToAllowedHostPaths(new AllowedHostPath(pathPrefix, readOnly));
    }

    public AllowedHostPathsNested<A> addNewAllowedHostPath() {
        return new AllowedHostPathsNested(-1, null);
    }

    public AllowedHostPathsNested<A> addNewAllowedHostPathLike(AllowedHostPath item) {
        return new AllowedHostPathsNested(-1, item);
    }

    public AllowedHostPathsNested<A> setNewAllowedHostPathLike(int index, AllowedHostPath item) {
        return new AllowedHostPathsNested(index, item);
    }

    public AllowedHostPathsNested<A> editAllowedHostPath(int index) {
        if (this.allowedHostPaths.size() <= index) {
            throw new RuntimeException("Can't edit allowedHostPaths. Index exceeds size.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    public AllowedHostPathsNested<A> editFirstAllowedHostPath() {
        if (this.allowedHostPaths.size() == 0) {
            throw new RuntimeException("Can't edit first allowedHostPaths. The list is empty.");
        }
        return this.setNewAllowedHostPathLike(0, this.buildAllowedHostPath(0));
    }

    public AllowedHostPathsNested<A> editLastAllowedHostPath() {
        int index = this.allowedHostPaths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allowedHostPaths. The list is empty.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    public AllowedHostPathsNested<A> editMatchingAllowedHostPath(Predicate<AllowedHostPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allowedHostPaths.size(); ++i) {
            if (!predicate.test(this.allowedHostPaths.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allowedHostPaths. No match found.");
        }
        return this.setNewAllowedHostPathLike(index, this.buildAllowedHostPath(index));
    }

    public A addToAllowedProcMountTypes(int index, String item) {
        if (this.allowedProcMountTypes == null) {
            this.allowedProcMountTypes = new ArrayList<String>();
        }
        this.allowedProcMountTypes.add(index, item);
        return (A)((Object)this);
    }

    public A setToAllowedProcMountTypes(int index, String item) {
        if (this.allowedProcMountTypes == null) {
            this.allowedProcMountTypes = new ArrayList<String>();
        }
        this.allowedProcMountTypes.set(index, item);
        return (A)((Object)this);
    }

    public A addToAllowedProcMountTypes(String ... items) {
        if (this.allowedProcMountTypes == null) {
            this.allowedProcMountTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedProcMountTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedProcMountTypes(Collection<String> items) {
        if (this.allowedProcMountTypes == null) {
            this.allowedProcMountTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedProcMountTypes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedProcMountTypes(String ... items) {
        if (this.allowedProcMountTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedProcMountTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedProcMountTypes(Collection<String> items) {
        if (this.allowedProcMountTypes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedProcMountTypes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAllowedProcMountTypes() {
        return this.allowedProcMountTypes;
    }

    public String getAllowedProcMountType(int index) {
        return this.allowedProcMountTypes.get(index);
    }

    public String getFirstAllowedProcMountType() {
        return this.allowedProcMountTypes.get(0);
    }

    public String getLastAllowedProcMountType() {
        return this.allowedProcMountTypes.get(this.allowedProcMountTypes.size() - 1);
    }

    public String getMatchingAllowedProcMountType(Predicate<String> predicate) {
        for (String item : this.allowedProcMountTypes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedProcMountType(Predicate<String> predicate) {
        for (String item : this.allowedProcMountTypes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedProcMountTypes(List<String> allowedProcMountTypes) {
        if (allowedProcMountTypes != null) {
            this.allowedProcMountTypes = new ArrayList<String>();
            for (String item : allowedProcMountTypes) {
                this.addToAllowedProcMountTypes(item);
            }
        } else {
            this.allowedProcMountTypes = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedProcMountTypes(String ... allowedProcMountTypes) {
        if (this.allowedProcMountTypes != null) {
            this.allowedProcMountTypes.clear();
            this._visitables.remove((Object)"allowedProcMountTypes");
        }
        if (allowedProcMountTypes != null) {
            for (String item : allowedProcMountTypes) {
                this.addToAllowedProcMountTypes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedProcMountTypes() {
        return this.allowedProcMountTypes != null && !this.allowedProcMountTypes.isEmpty();
    }

    public A addToAllowedUnsafeSysctls(int index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.add(index, item);
        return (A)((Object)this);
    }

    public A setToAllowedUnsafeSysctls(int index, String item) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        this.allowedUnsafeSysctls.set(index, item);
        return (A)((Object)this);
    }

    public A addToAllowedUnsafeSysctls(String ... items) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAllowedUnsafeSysctls(Collection<String> items) {
        if (this.allowedUnsafeSysctls == null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAllowedUnsafeSysctls(String ... items) {
        if (this.allowedUnsafeSysctls == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items) {
        if (this.allowedUnsafeSysctls == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.allowedUnsafeSysctls.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls;
    }

    public String getAllowedUnsafeSysctl(int index) {
        return this.allowedUnsafeSysctls.get(index);
    }

    public String getFirstAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(0);
    }

    public String getLastAllowedUnsafeSysctl() {
        return this.allowedUnsafeSysctls.get(this.allowedUnsafeSysctls.size() - 1);
    }

    public String getMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAllowedUnsafeSysctl(Predicate<String> predicate) {
        for (String item : this.allowedUnsafeSysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls) {
        if (allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls = new ArrayList<String>();
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        } else {
            this.allowedUnsafeSysctls = null;
        }
        return (A)((Object)this);
    }

    public A withAllowedUnsafeSysctls(String ... allowedUnsafeSysctls) {
        if (this.allowedUnsafeSysctls != null) {
            this.allowedUnsafeSysctls.clear();
            this._visitables.remove((Object)"allowedUnsafeSysctls");
        }
        if (allowedUnsafeSysctls != null) {
            for (String item : allowedUnsafeSysctls) {
                this.addToAllowedUnsafeSysctls(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAllowedUnsafeSysctls() {
        return this.allowedUnsafeSysctls != null && !this.allowedUnsafeSysctls.isEmpty();
    }

    public A addToDefaultAddCapabilities(int index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.add(index, item);
        return (A)((Object)this);
    }

    public A setToDefaultAddCapabilities(int index, String item) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        this.defaultAddCapabilities.set(index, item);
        return (A)((Object)this);
    }

    public A addToDefaultAddCapabilities(String ... items) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDefaultAddCapabilities(Collection<String> items) {
        if (this.defaultAddCapabilities == null) {
            this.defaultAddCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDefaultAddCapabilities(String ... items) {
        if (this.defaultAddCapabilities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
        if (this.defaultAddCapabilities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    public String getDefaultAddCapability(int index) {
        return this.defaultAddCapabilities.get(index);
    }

    public String getFirstDefaultAddCapability() {
        return this.defaultAddCapabilities.get(0);
    }

    public String getLastDefaultAddCapability() {
        return this.defaultAddCapabilities.get(this.defaultAddCapabilities.size() - 1);
    }

    public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        if (defaultAddCapabilities != null) {
            this.defaultAddCapabilities = new ArrayList<String>();
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        } else {
            this.defaultAddCapabilities = null;
        }
        return (A)((Object)this);
    }

    public A withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        if (this.defaultAddCapabilities != null) {
            this.defaultAddCapabilities.clear();
            this._visitables.remove((Object)"defaultAddCapabilities");
        }
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDefaultAddCapabilities() {
        return this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty();
    }

    public Boolean getDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation;
    }

    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation) {
        this.defaultAllowPrivilegeEscalation = defaultAllowPrivilegeEscalation;
        return (A)((Object)this);
    }

    public boolean hasDefaultAllowPrivilegeEscalation() {
        return this.defaultAllowPrivilegeEscalation != null;
    }

    public A addToForbiddenSysctls(int index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.add(index, item);
        return (A)((Object)this);
    }

    public A setToForbiddenSysctls(int index, String item) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        this.forbiddenSysctls.set(index, item);
        return (A)((Object)this);
    }

    public A addToForbiddenSysctls(String ... items) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToForbiddenSysctls(Collection<String> items) {
        if (this.forbiddenSysctls == null) {
            this.forbiddenSysctls = new ArrayList<String>();
        }
        for (String item : items) {
            this.forbiddenSysctls.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromForbiddenSysctls(String ... items) {
        if (this.forbiddenSysctls == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.forbiddenSysctls.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromForbiddenSysctls(Collection<String> items) {
        if (this.forbiddenSysctls == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.forbiddenSysctls.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getForbiddenSysctls() {
        return this.forbiddenSysctls;
    }

    public String getForbiddenSysctl(int index) {
        return this.forbiddenSysctls.get(index);
    }

    public String getFirstForbiddenSysctl() {
        return this.forbiddenSysctls.get(0);
    }

    public String getLastForbiddenSysctl() {
        return this.forbiddenSysctls.get(this.forbiddenSysctls.size() - 1);
    }

    public String getMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingForbiddenSysctl(Predicate<String> predicate) {
        for (String item : this.forbiddenSysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withForbiddenSysctls(List<String> forbiddenSysctls) {
        if (forbiddenSysctls != null) {
            this.forbiddenSysctls = new ArrayList<String>();
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        } else {
            this.forbiddenSysctls = null;
        }
        return (A)((Object)this);
    }

    public A withForbiddenSysctls(String ... forbiddenSysctls) {
        if (this.forbiddenSysctls != null) {
            this.forbiddenSysctls.clear();
            this._visitables.remove((Object)"forbiddenSysctls");
        }
        if (forbiddenSysctls != null) {
            for (String item : forbiddenSysctls) {
                this.addToForbiddenSysctls(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasForbiddenSysctls() {
        return this.forbiddenSysctls != null && !this.forbiddenSysctls.isEmpty();
    }

    public FSGroupStrategyOptions buildFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    public A withFsGroup(FSGroupStrategyOptions fsGroup) {
        this._visitables.get((Object)"fsGroup").remove((Object)this.fsGroup);
        if (fsGroup != null) {
            this.fsGroup = new FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.get((Object)"fsGroup").add(this.fsGroup);
        } else {
            this.fsGroup = null;
            this._visitables.get((Object)"fsGroup").remove((Object)this.fsGroup);
        }
        return (A)((Object)this);
    }

    public boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    public FsGroupNested<A> withNewFsGroup() {
        return new FsGroupNested(null);
    }

    public FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
        return new FsGroupNested(item);
    }

    public FsGroupNested<A> editFsGroup() {
        return this.withNewFsGroupLike(Optional.ofNullable(this.buildFsGroup()).orElse(null));
    }

    public FsGroupNested<A> editOrNewFsGroup() {
        return this.withNewFsGroupLike(Optional.ofNullable(this.buildFsGroup()).orElse(new FSGroupStrategyOptionsBuilder().build()));
    }

    public FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item) {
        return this.withNewFsGroupLike(Optional.ofNullable(this.buildFsGroup()).orElse(item));
    }

    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)((Object)this);
    }

    public boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)((Object)this);
    }

    public boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public Boolean getHostPID() {
        return this.hostPID;
    }

    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)((Object)this);
    }

    public boolean hasHostPID() {
        return this.hostPID != null;
    }

    public A addToHostPorts(int index, HostPortRange item) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList();
        }
        HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
        if (index < 0 || index >= this.hostPorts.size()) {
            this._visitables.get((Object)"hostPorts").add(builder);
            this.hostPorts.add(builder);
        } else {
            this._visitables.get((Object)"hostPorts").add(index, builder);
            this.hostPorts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHostPorts(int index, HostPortRange item) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList();
        }
        HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
        if (index < 0 || index >= this.hostPorts.size()) {
            this._visitables.get((Object)"hostPorts").add(builder);
            this.hostPorts.add(builder);
        } else {
            this._visitables.get((Object)"hostPorts").set(index, builder);
            this.hostPorts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHostPorts(HostPortRange ... items) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList();
        }
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.get((Object)"hostPorts").add(builder);
            this.hostPorts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHostPorts(Collection<HostPortRange> items) {
        if (this.hostPorts == null) {
            this.hostPorts = new ArrayList();
        }
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.get((Object)"hostPorts").add(builder);
            this.hostPorts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHostPorts(HostPortRange ... items) {
        if (this.hostPorts == null) {
            return (A)((Object)this);
        }
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.get((Object)"hostPorts").remove((Object)builder);
            this.hostPorts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHostPorts(Collection<HostPortRange> items) {
        if (this.hostPorts == null) {
            return (A)((Object)this);
        }
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.get((Object)"hostPorts").remove((Object)builder);
            this.hostPorts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHostPorts(Predicate<HostPortRangeBuilder> predicate) {
        if (this.hostPorts == null) {
            return (A)((Object)this);
        }
        Iterator<HostPortRangeBuilder> each = this.hostPorts.iterator();
        List visitables = this._visitables.get((Object)"hostPorts");
        while (each.hasNext()) {
            HostPortRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HostPortRange> buildHostPorts() {
        return this.hostPorts != null ? PodSecurityPolicySpecFluent.build(this.hostPorts) : null;
    }

    public HostPortRange buildHostPort(int index) {
        return this.hostPorts.get(index).build();
    }

    public HostPortRange buildFirstHostPort() {
        return this.hostPorts.get(0).build();
    }

    public HostPortRange buildLastHostPort() {
        return this.hostPorts.get(this.hostPorts.size() - 1).build();
    }

    public HostPortRange buildMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
        for (HostPortRangeBuilder item : this.hostPorts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
        for (HostPortRangeBuilder item : this.hostPorts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostPorts(List<HostPortRange> hostPorts) {
        if (this.hostPorts != null) {
            this._visitables.get((Object)"hostPorts").clear();
        }
        if (hostPorts != null) {
            this.hostPorts = new ArrayList();
            for (HostPortRange item : hostPorts) {
                this.addToHostPorts(item);
            }
        } else {
            this.hostPorts = null;
        }
        return (A)((Object)this);
    }

    public A withHostPorts(HostPortRange ... hostPorts) {
        if (this.hostPorts != null) {
            this.hostPorts.clear();
            this._visitables.remove((Object)"hostPorts");
        }
        if (hostPorts != null) {
            for (HostPortRange item : hostPorts) {
                this.addToHostPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHostPorts() {
        return this.hostPorts != null && !this.hostPorts.isEmpty();
    }

    public A addNewHostPort(Integer max, Integer min) {
        return this.addToHostPorts(new HostPortRange(max, min));
    }

    public HostPortsNested<A> addNewHostPort() {
        return new HostPortsNested(-1, null);
    }

    public HostPortsNested<A> addNewHostPortLike(HostPortRange item) {
        return new HostPortsNested(-1, item);
    }

    public HostPortsNested<A> setNewHostPortLike(int index, HostPortRange item) {
        return new HostPortsNested(index, item);
    }

    public HostPortsNested<A> editHostPort(int index) {
        if (this.hostPorts.size() <= index) {
            throw new RuntimeException("Can't edit hostPorts. Index exceeds size.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    public HostPortsNested<A> editFirstHostPort() {
        if (this.hostPorts.size() == 0) {
            throw new RuntimeException("Can't edit first hostPorts. The list is empty.");
        }
        return this.setNewHostPortLike(0, this.buildHostPort(0));
    }

    public HostPortsNested<A> editLastHostPort() {
        int index = this.hostPorts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostPorts. The list is empty.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    public HostPortsNested<A> editMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostPorts.size(); ++i) {
            if (!predicate.test(this.hostPorts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostPorts. No match found.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public A withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (A)((Object)this);
    }

    public boolean hasPrivileged() {
        return this.privileged != null;
    }

    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)((Object)this);
    }

    public boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    public A addToRequiredDropCapabilities(int index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.add(index, item);
        return (A)((Object)this);
    }

    public A setToRequiredDropCapabilities(int index, String item) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        this.requiredDropCapabilities.set(index, item);
        return (A)((Object)this);
    }

    public A addToRequiredDropCapabilities(String ... items) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRequiredDropCapabilities(Collection<String> items) {
        if (this.requiredDropCapabilities == null) {
            this.requiredDropCapabilities = new ArrayList<String>();
        }
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRequiredDropCapabilities(String ... items) {
        if (this.requiredDropCapabilities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
        if (this.requiredDropCapabilities == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    public String getRequiredDropCapability(int index) {
        return this.requiredDropCapabilities.get(index);
    }

    public String getFirstRequiredDropCapability() {
        return this.requiredDropCapabilities.get(0);
    }

    public String getLastRequiredDropCapability() {
        return this.requiredDropCapabilities.get(this.requiredDropCapabilities.size() - 1);
    }

    public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        if (requiredDropCapabilities != null) {
            this.requiredDropCapabilities = new ArrayList<String>();
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        } else {
            this.requiredDropCapabilities = null;
        }
        return (A)((Object)this);
    }

    public A withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        if (this.requiredDropCapabilities != null) {
            this.requiredDropCapabilities.clear();
            this._visitables.remove((Object)"requiredDropCapabilities");
        }
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRequiredDropCapabilities() {
        return this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty();
    }

    public RunAsGroupStrategyOptions buildRunAsGroup() {
        return this.runAsGroup != null ? this.runAsGroup.build() : null;
    }

    public A withRunAsGroup(RunAsGroupStrategyOptions runAsGroup) {
        this._visitables.get((Object)"runAsGroup").remove((Object)this.runAsGroup);
        if (runAsGroup != null) {
            this.runAsGroup = new RunAsGroupStrategyOptionsBuilder(runAsGroup);
            this._visitables.get((Object)"runAsGroup").add(this.runAsGroup);
        } else {
            this.runAsGroup = null;
            this._visitables.get((Object)"runAsGroup").remove((Object)this.runAsGroup);
        }
        return (A)((Object)this);
    }

    public boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    public RunAsGroupNested<A> withNewRunAsGroup() {
        return new RunAsGroupNested(null);
    }

    public RunAsGroupNested<A> withNewRunAsGroupLike(RunAsGroupStrategyOptions item) {
        return new RunAsGroupNested(item);
    }

    public RunAsGroupNested<A> editRunAsGroup() {
        return this.withNewRunAsGroupLike(Optional.ofNullable(this.buildRunAsGroup()).orElse(null));
    }

    public RunAsGroupNested<A> editOrNewRunAsGroup() {
        return this.withNewRunAsGroupLike(Optional.ofNullable(this.buildRunAsGroup()).orElse(new RunAsGroupStrategyOptionsBuilder().build()));
    }

    public RunAsGroupNested<A> editOrNewRunAsGroupLike(RunAsGroupStrategyOptions item) {
        return this.withNewRunAsGroupLike(Optional.ofNullable(this.buildRunAsGroup()).orElse(item));
    }

    public RunAsUserStrategyOptions buildRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    public A withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this._visitables.get((Object)"runAsUser").remove((Object)this.runAsUser);
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.get((Object)"runAsUser").add(this.runAsUser);
        } else {
            this.runAsUser = null;
            this._visitables.get((Object)"runAsUser").remove((Object)this.runAsUser);
        }
        return (A)((Object)this);
    }

    public boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public RunAsUserNested<A> withNewRunAsUser() {
        return new RunAsUserNested(null);
    }

    public RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNested(item);
    }

    public RunAsUserNested<A> editRunAsUser() {
        return this.withNewRunAsUserLike(Optional.ofNullable(this.buildRunAsUser()).orElse(null));
    }

    public RunAsUserNested<A> editOrNewRunAsUser() {
        return this.withNewRunAsUserLike(Optional.ofNullable(this.buildRunAsUser()).orElse(new RunAsUserStrategyOptionsBuilder().build()));
    }

    public RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return this.withNewRunAsUserLike(Optional.ofNullable(this.buildRunAsUser()).orElse(item));
    }

    public RuntimeClassStrategyOptions buildRuntimeClass() {
        return this.runtimeClass != null ? this.runtimeClass.build() : null;
    }

    public A withRuntimeClass(RuntimeClassStrategyOptions runtimeClass) {
        this._visitables.get((Object)"runtimeClass").remove((Object)this.runtimeClass);
        if (runtimeClass != null) {
            this.runtimeClass = new RuntimeClassStrategyOptionsBuilder(runtimeClass);
            this._visitables.get((Object)"runtimeClass").add(this.runtimeClass);
        } else {
            this.runtimeClass = null;
            this._visitables.get((Object)"runtimeClass").remove((Object)this.runtimeClass);
        }
        return (A)((Object)this);
    }

    public boolean hasRuntimeClass() {
        return this.runtimeClass != null;
    }

    public RuntimeClassNested<A> withNewRuntimeClass() {
        return new RuntimeClassNested(null);
    }

    public RuntimeClassNested<A> withNewRuntimeClassLike(RuntimeClassStrategyOptions item) {
        return new RuntimeClassNested(item);
    }

    public RuntimeClassNested<A> editRuntimeClass() {
        return this.withNewRuntimeClassLike(Optional.ofNullable(this.buildRuntimeClass()).orElse(null));
    }

    public RuntimeClassNested<A> editOrNewRuntimeClass() {
        return this.withNewRuntimeClassLike(Optional.ofNullable(this.buildRuntimeClass()).orElse(new RuntimeClassStrategyOptionsBuilder().build()));
    }

    public RuntimeClassNested<A> editOrNewRuntimeClassLike(RuntimeClassStrategyOptions item) {
        return this.withNewRuntimeClassLike(Optional.ofNullable(this.buildRuntimeClass()).orElse(item));
    }

    public SELinuxStrategyOptions buildSeLinux() {
        return this.seLinux != null ? this.seLinux.build() : null;
    }

    public A withSeLinux(SELinuxStrategyOptions seLinux) {
        this._visitables.get((Object)"seLinux").remove((Object)this.seLinux);
        if (seLinux != null) {
            this.seLinux = new SELinuxStrategyOptionsBuilder(seLinux);
            this._visitables.get((Object)"seLinux").add(this.seLinux);
        } else {
            this.seLinux = null;
            this._visitables.get((Object)"seLinux").remove((Object)this.seLinux);
        }
        return (A)((Object)this);
    }

    public boolean hasSeLinux() {
        return this.seLinux != null;
    }

    public SeLinuxNested<A> withNewSeLinux() {
        return new SeLinuxNested(null);
    }

    public SeLinuxNested<A> withNewSeLinuxLike(SELinuxStrategyOptions item) {
        return new SeLinuxNested(item);
    }

    public SeLinuxNested<A> editSeLinux() {
        return this.withNewSeLinuxLike(Optional.ofNullable(this.buildSeLinux()).orElse(null));
    }

    public SeLinuxNested<A> editOrNewSeLinux() {
        return this.withNewSeLinuxLike(Optional.ofNullable(this.buildSeLinux()).orElse(new SELinuxStrategyOptionsBuilder().build()));
    }

    public SeLinuxNested<A> editOrNewSeLinuxLike(SELinuxStrategyOptions item) {
        return this.withNewSeLinuxLike(Optional.ofNullable(this.buildSeLinux()).orElse(item));
    }

    public SupplementalGroupsStrategyOptions buildSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        this._visitables.get((Object)"supplementalGroups").remove((Object)this.supplementalGroups);
        if (supplementalGroups != null) {
            this.supplementalGroups = new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.get((Object)"supplementalGroups").add(this.supplementalGroups);
        } else {
            this.supplementalGroups = null;
            this._visitables.get((Object)"supplementalGroups").remove((Object)this.supplementalGroups);
        }
        return (A)((Object)this);
    }

    public boolean hasSupplementalGroups() {
        return this.supplementalGroups != null;
    }

    public SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new SupplementalGroupsNested(null);
    }

    public SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNested(item);
    }

    public SupplementalGroupsNested<A> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(Optional.ofNullable(this.buildSupplementalGroups()).orElse(null));
    }

    public SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(Optional.ofNullable(this.buildSupplementalGroups()).orElse(new SupplementalGroupsStrategyOptionsBuilder().build()));
    }

    public SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return this.withNewSupplementalGroupsLike(Optional.ofNullable(this.buildSupplementalGroups()).orElse(item));
    }

    public A addToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.add(index, item);
        return (A)((Object)this);
    }

    public A setToVolumes(int index, String item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        this.volumes.set(index, item);
        return (A)((Object)this);
    }

    public A addToVolumes(String ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumes(Collection<String> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(String ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumes(Collection<String> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVolumes() {
        return this.volumes;
    }

    public String getVolume(int index) {
        return this.volumes.get(index);
    }

    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<String> volumes) {
        if (volumes != null) {
            this.volumes = new ArrayList<String>();
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(String ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicySpecFluent that = (PodSecurityPolicySpecFluent)((Object)o);
        if (!Objects.equals(this.allowPrivilegeEscalation, that.allowPrivilegeEscalation)) {
            return false;
        }
        if (!Objects.equals(this.allowedCSIDrivers, that.allowedCSIDrivers)) {
            return false;
        }
        if (!Objects.equals(this.allowedCapabilities, that.allowedCapabilities)) {
            return false;
        }
        if (!Objects.equals(this.allowedFlexVolumes, that.allowedFlexVolumes)) {
            return false;
        }
        if (!Objects.equals(this.allowedHostPaths, that.allowedHostPaths)) {
            return false;
        }
        if (!Objects.equals(this.allowedProcMountTypes, that.allowedProcMountTypes)) {
            return false;
        }
        if (!Objects.equals(this.allowedUnsafeSysctls, that.allowedUnsafeSysctls)) {
            return false;
        }
        if (!Objects.equals(this.defaultAddCapabilities, that.defaultAddCapabilities)) {
            return false;
        }
        if (!Objects.equals(this.defaultAllowPrivilegeEscalation, that.defaultAllowPrivilegeEscalation)) {
            return false;
        }
        if (!Objects.equals(this.forbiddenSysctls, that.forbiddenSysctls)) {
            return false;
        }
        if (!Objects.equals((Object)this.fsGroup, (Object)that.fsGroup)) {
            return false;
        }
        if (!Objects.equals(this.hostIPC, that.hostIPC)) {
            return false;
        }
        if (!Objects.equals(this.hostNetwork, that.hostNetwork)) {
            return false;
        }
        if (!Objects.equals(this.hostPID, that.hostPID)) {
            return false;
        }
        if (!Objects.equals(this.hostPorts, that.hostPorts)) {
            return false;
        }
        if (!Objects.equals(this.privileged, that.privileged)) {
            return false;
        }
        if (!Objects.equals(this.readOnlyRootFilesystem, that.readOnlyRootFilesystem)) {
            return false;
        }
        if (!Objects.equals(this.requiredDropCapabilities, that.requiredDropCapabilities)) {
            return false;
        }
        if (!Objects.equals((Object)this.runAsGroup, (Object)that.runAsGroup)) {
            return false;
        }
        if (!Objects.equals((Object)this.runAsUser, (Object)that.runAsUser)) {
            return false;
        }
        if (!Objects.equals((Object)this.runtimeClass, (Object)that.runtimeClass)) {
            return false;
        }
        if (!Objects.equals((Object)this.seLinux, (Object)that.seLinux)) {
            return false;
        }
        if (!Objects.equals((Object)this.supplementalGroups, (Object)that.supplementalGroups)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowPrivilegeEscalation, this.allowedCSIDrivers, this.allowedCapabilities, this.allowedFlexVolumes, this.allowedHostPaths, this.allowedProcMountTypes, this.allowedUnsafeSysctls, this.defaultAddCapabilities, this.defaultAllowPrivilegeEscalation, this.forbiddenSysctls, this.fsGroup, this.hostIPC, this.hostNetwork, this.hostPID, this.hostPorts, this.privileged, this.readOnlyRootFilesystem, this.requiredDropCapabilities, this.runAsGroup, this.runAsUser, this.runtimeClass, this.seLinux, this.supplementalGroups, this.volumes, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowPrivilegeEscalation != null) {
            sb.append("allowPrivilegeEscalation:");
            sb.append(this.allowPrivilegeEscalation + ",");
        }
        if (this.allowedCSIDrivers != null && !this.allowedCSIDrivers.isEmpty()) {
            sb.append("allowedCSIDrivers:");
            sb.append(this.allowedCSIDrivers + ",");
        }
        if (this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty()) {
            sb.append("allowedCapabilities:");
            sb.append(this.allowedCapabilities + ",");
        }
        if (this.allowedFlexVolumes != null && !this.allowedFlexVolumes.isEmpty()) {
            sb.append("allowedFlexVolumes:");
            sb.append(this.allowedFlexVolumes + ",");
        }
        if (this.allowedHostPaths != null && !this.allowedHostPaths.isEmpty()) {
            sb.append("allowedHostPaths:");
            sb.append(this.allowedHostPaths + ",");
        }
        if (this.allowedProcMountTypes != null && !this.allowedProcMountTypes.isEmpty()) {
            sb.append("allowedProcMountTypes:");
            sb.append(this.allowedProcMountTypes + ",");
        }
        if (this.allowedUnsafeSysctls != null && !this.allowedUnsafeSysctls.isEmpty()) {
            sb.append("allowedUnsafeSysctls:");
            sb.append(this.allowedUnsafeSysctls + ",");
        }
        if (this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty()) {
            sb.append("defaultAddCapabilities:");
            sb.append(this.defaultAddCapabilities + ",");
        }
        if (this.defaultAllowPrivilegeEscalation != null) {
            sb.append("defaultAllowPrivilegeEscalation:");
            sb.append(this.defaultAllowPrivilegeEscalation + ",");
        }
        if (this.forbiddenSysctls != null && !this.forbiddenSysctls.isEmpty()) {
            sb.append("forbiddenSysctls:");
            sb.append(this.forbiddenSysctls + ",");
        }
        if (this.fsGroup != null) {
            sb.append("fsGroup:");
            sb.append((Object)((Object)this.fsGroup) + ",");
        }
        if (this.hostIPC != null) {
            sb.append("hostIPC:");
            sb.append(this.hostIPC + ",");
        }
        if (this.hostNetwork != null) {
            sb.append("hostNetwork:");
            sb.append(this.hostNetwork + ",");
        }
        if (this.hostPID != null) {
            sb.append("hostPID:");
            sb.append(this.hostPID + ",");
        }
        if (this.hostPorts != null && !this.hostPorts.isEmpty()) {
            sb.append("hostPorts:");
            sb.append(this.hostPorts + ",");
        }
        if (this.privileged != null) {
            sb.append("privileged:");
            sb.append(this.privileged + ",");
        }
        if (this.readOnlyRootFilesystem != null) {
            sb.append("readOnlyRootFilesystem:");
            sb.append(this.readOnlyRootFilesystem + ",");
        }
        if (this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty()) {
            sb.append("requiredDropCapabilities:");
            sb.append(this.requiredDropCapabilities + ",");
        }
        if (this.runAsGroup != null) {
            sb.append("runAsGroup:");
            sb.append((Object)((Object)this.runAsGroup) + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append((Object)((Object)this.runAsUser) + ",");
        }
        if (this.runtimeClass != null) {
            sb.append("runtimeClass:");
            sb.append((Object)((Object)this.runtimeClass) + ",");
        }
        if (this.seLinux != null) {
            sb.append("seLinux:");
            sb.append((Object)((Object)this.seLinux) + ",");
        }
        if (this.supplementalGroups != null) {
            sb.append("supplementalGroups:");
            sb.append((Object)((Object)this.supplementalGroups) + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowPrivilegeEscalation() {
        return this.withAllowPrivilegeEscalation(true);
    }

    public A withDefaultAllowPrivilegeEscalation() {
        return this.withDefaultAllowPrivilegeEscalation(true);
    }

    public A withHostIPC() {
        return this.withHostIPC(true);
    }

    public A withHostNetwork() {
        return this.withHostNetwork(true);
    }

    public A withHostPID() {
        return this.withHostPID(true);
    }

    public A withPrivileged() {
        return this.withPrivileged(true);
    }

    public A withReadOnlyRootFilesystem() {
        return this.withReadOnlyRootFilesystem(true);
    }

    public class SupplementalGroupsNested<N>
    extends SupplementalGroupsStrategyOptionsFluent<SupplementalGroupsNested<N>>
    implements Nested<N> {
        SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNested(SupplementalGroupsStrategyOptions item) {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.withSupplementalGroups(this.builder.build());
        }

        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxNested<N>
    extends SELinuxStrategyOptionsFluent<SeLinuxNested<N>>
    implements Nested<N> {
        SELinuxStrategyOptionsBuilder builder;

        SeLinuxNested(SELinuxStrategyOptions item) {
            this.builder = new SELinuxStrategyOptionsBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.withSeLinux(this.builder.build());
        }

        public N endSeLinux() {
            return this.and();
        }
    }

    public class RuntimeClassNested<N>
    extends RuntimeClassStrategyOptionsFluent<RuntimeClassNested<N>>
    implements Nested<N> {
        RuntimeClassStrategyOptionsBuilder builder;

        RuntimeClassNested(RuntimeClassStrategyOptions item) {
            this.builder = new RuntimeClassStrategyOptionsBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.withRuntimeClass(this.builder.build());
        }

        public N endRuntimeClass() {
            return this.and();
        }
    }

    public class RunAsUserNested<N>
    extends RunAsUserStrategyOptionsFluent<RunAsUserNested<N>>
    implements Nested<N> {
        RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNested(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.withRunAsUser(this.builder.build());
        }

        public N endRunAsUser() {
            return this.and();
        }
    }

    public class RunAsGroupNested<N>
    extends RunAsGroupStrategyOptionsFluent<RunAsGroupNested<N>>
    implements Nested<N> {
        RunAsGroupStrategyOptionsBuilder builder;

        RunAsGroupNested(RunAsGroupStrategyOptions item) {
            this.builder = new RunAsGroupStrategyOptionsBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.withRunAsGroup(this.builder.build());
        }

        public N endRunAsGroup() {
            return this.and();
        }
    }

    public class HostPortsNested<N>
    extends HostPortRangeFluent<HostPortsNested<N>>
    implements Nested<N> {
        HostPortRangeBuilder builder;
        int index;

        HostPortsNested(int index, HostPortRange item) {
            this.index = index;
            this.builder = new HostPortRangeBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.setToHostPorts(this.index, this.builder.build());
        }

        public N endHostPort() {
            return this.and();
        }
    }

    public class FsGroupNested<N>
    extends FSGroupStrategyOptionsFluent<FsGroupNested<N>>
    implements Nested<N> {
        FSGroupStrategyOptionsBuilder builder;

        FsGroupNested(FSGroupStrategyOptions item) {
            this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.withFsGroup(this.builder.build());
        }

        public N endFsGroup() {
            return this.and();
        }
    }

    public class AllowedHostPathsNested<N>
    extends AllowedHostPathFluent<AllowedHostPathsNested<N>>
    implements Nested<N> {
        AllowedHostPathBuilder builder;
        int index;

        AllowedHostPathsNested(int index, AllowedHostPath item) {
            this.index = index;
            this.builder = new AllowedHostPathBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.setToAllowedHostPaths(this.index, this.builder.build());
        }

        public N endAllowedHostPath() {
            return this.and();
        }
    }

    public class AllowedFlexVolumesNested<N>
    extends AllowedFlexVolumeFluent<AllowedFlexVolumesNested<N>>
    implements Nested<N> {
        AllowedFlexVolumeBuilder builder;
        int index;

        AllowedFlexVolumesNested(int index, AllowedFlexVolume item) {
            this.index = index;
            this.builder = new AllowedFlexVolumeBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.setToAllowedFlexVolumes(this.index, this.builder.build());
        }

        public N endAllowedFlexVolume() {
            return this.and();
        }
    }

    public class AllowedCSIDriversNested<N>
    extends AllowedCSIDriverFluent<AllowedCSIDriversNested<N>>
    implements Nested<N> {
        AllowedCSIDriverBuilder builder;
        int index;

        AllowedCSIDriversNested(int index, AllowedCSIDriver item) {
            this.index = index;
            this.builder = new AllowedCSIDriverBuilder(this, item);
        }

        public N and() {
            return (N)PodSecurityPolicySpecFluent.this.setToAllowedCSIDrivers(this.index, this.builder.build());
        }

        public N endAllowedCSIDriver() {
            return this.and();
        }
    }
}

