package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RunAsGroupStrategyOptionsBuilder extends RunAsGroupStrategyOptionsFluent<RunAsGroupStrategyOptionsBuilder> implements VisitableBuilder<RunAsGroupStrategyOptions,RunAsGroupStrategyOptionsBuilder>{
  public RunAsGroupStrategyOptionsBuilder() {
    this(false);
  }
  public RunAsGroupStrategyOptionsBuilder(Boolean validationEnabled) {
    this(new RunAsGroupStrategyOptions(), validationEnabled);
  }
  public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RunAsGroupStrategyOptions(), validationEnabled);
  }
  public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent,RunAsGroupStrategyOptions instance) {
    this(fluent, instance, false);
  }
  public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent,RunAsGroupStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RunAsGroupStrategyOptions());

    if (instance != null) {
      fluent.withRanges(instance.getRanges());
      fluent.withRule(instance.getRule());
      fluent.withRanges(instance.getRanges());
      fluent.withRule(instance.getRule());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptions instance) {
    this(instance,false);
  }
  public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RunAsGroupStrategyOptions());

    if (instance != null) {
      this.withRanges(instance.getRanges());
      this.withRule(instance.getRule());
      this.withRanges(instance.getRanges());
      this.withRule(instance.getRule());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RunAsGroupStrategyOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public RunAsGroupStrategyOptions build() {
    RunAsGroupStrategyOptions buildable = new RunAsGroupStrategyOptions(fluent.buildRanges(),fluent.getRule());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}