package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDisruptionBudgetSpecBuilder extends PodDisruptionBudgetSpecFluent<PodDisruptionBudgetSpecBuilder> implements VisitableBuilder<PodDisruptionBudgetSpec,PodDisruptionBudgetSpecBuilder>{
  public PodDisruptionBudgetSpecBuilder() {
    this(false);
  }
  public PodDisruptionBudgetSpecBuilder(Boolean validationEnabled) {
    this(new PodDisruptionBudgetSpec(), validationEnabled);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodDisruptionBudgetSpec(), validationEnabled);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent,PodDisruptionBudgetSpec instance) {
    this(fluent, instance, false);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpecFluent<?> fluent,PodDisruptionBudgetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PodDisruptionBudgetSpec());

    if (instance != null) {
      fluent.withMaxUnavailable(instance.getMaxUnavailable());
      fluent.withMinAvailable(instance.getMinAvailable());
      fluent.withSelector(instance.getSelector());
      fluent.withUnhealthyPodEvictionPolicy(instance.getUnhealthyPodEvictionPolicy());
      fluent.withMaxUnavailable(instance.getMaxUnavailable());
      fluent.withMinAvailable(instance.getMinAvailable());
      fluent.withSelector(instance.getSelector());
      fluent.withUnhealthyPodEvictionPolicy(instance.getUnhealthyPodEvictionPolicy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpec instance) {
    this(instance,false);
  }
  public PodDisruptionBudgetSpecBuilder(PodDisruptionBudgetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PodDisruptionBudgetSpec());

    if (instance != null) {
      this.withMaxUnavailable(instance.getMaxUnavailable());
      this.withMinAvailable(instance.getMinAvailable());
      this.withSelector(instance.getSelector());
      this.withUnhealthyPodEvictionPolicy(instance.getUnhealthyPodEvictionPolicy());
      this.withMaxUnavailable(instance.getMaxUnavailable());
      this.withMinAvailable(instance.getMinAvailable());
      this.withSelector(instance.getSelector());
      this.withUnhealthyPodEvictionPolicy(instance.getUnhealthyPodEvictionPolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodDisruptionBudgetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PodDisruptionBudgetSpec build() {
    PodDisruptionBudgetSpec buildable = new PodDisruptionBudgetSpec(fluent.buildMaxUnavailable(),fluent.buildMinAvailable(),fluent.buildSelector(),fluent.getUnhealthyPodEvictionPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}